package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;

public class GenImportType extends GenType {
	
	protected GenImportType(final String name) {
		super(name);
	}
	
	public static GenImportType create(final String importString) {
		return new GenImportType(importString);
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return this.getName();
	}
	
	@Override
	public String getFullyQualifiedTypeNameWithGenericArguments() {
		return this.getFullyQualifiedTypeName();
	}
	
	@Override
	public void accept(final GenTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
}
