package de.fhdw.wtf.generator.java.generatorModel;

/**
 * A GenOperationModifier represents one of all possible modifiers for java-operations. For example "abstract" and
 * "static".
 */
public enum GenOperationModifier {
	/**
	 * The {@link GenOperationModifier} "abstract" declares that an operation is not implemented and needs to be
	 * implemented by concrete subclasses.
	 */
	ABSTRACT("abstract"),
	/**
	 * The {@link GenOperationModifier} "static" declares that the operation can be called without having to instantiate
	 * an object of the class containing the static operation.
	 */
	STATIC("static");
	
	/**
	 * The String-representation of this {@link GenOperationModifier}.
	 */
	private final String t;
	
	/**
	 * Instantiates a new {@link GenOperationModifier}.
	 * 
	 * @param t
	 *            The String-representation of the GenOperationModifier.
	 */
	GenOperationModifier(final String t) {
		this.t = t;
	}
	
	@Override
	public String toString() {
		return this.t;
	}
}
