package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitorReturn;

/**
 * The GenUserClassGeneratedAsState decides whether a UserClass will be generated as java-class or as java-interface
 * containing a java-class called "Impl".
 * 
 * If the state ends with "GenerateAsClass" just generate the GenUserClass.
 */
public final class GenerateAsClassState extends GenerateAsState {
	
	/**
	 * Constructor of GenerateAsClassState.
	 */
	public GenerateAsClassState() {
		super();
	}
	
	@Override
	public void accept(final GenerateAsStateVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenerateAsStateVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
