package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenerateAsStateVisitorReturn;

/**
 * The GenerateAsState decides whether a UserClass will be generated as java-class or as java-interface containing a
 * java-class called "Impl".
 * 
 * If the state ends with "GenerateAsClass" just generate the GenUserClass.
 * 
 * If the state ends with "GenerateAsInterfaceWithImpl" generate an interface with the name of the GenUserClass and all
 * public operations, that contains the GenUserClass as private inner class with the name "Impl".
 */
public abstract class GenerateAsState {
	
	/**
	 * Constructor of GenUserClassGeneratedAsState.
	 */
	protected GenerateAsState() {
		super();
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(final GenerateAsStateVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenerateAsStateVisitorReturn<X> visitor);
}
