/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.database.tasks;

import de.fhdw.wtf.common.ast.DatabaseIDSetState;
import de.fhdw.wtf.common.ast.DatabaseIDState;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.context.model.collections.PersistentList;
import de.fhdw.wtf.context.model.collections.PersistentMap;
import de.fhdw.wtf.generator.database.generation.InitialGenerator;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;

public class TypeGenerationTask
extends SimpleWalkerTaskForTypes {
    private final InitialGenerator generator;
    private final GeneratorModel genModel;

    public TypeGenerationTask(Model m, GeneratorModel genModel, TaskExecutor man, InitialGenerator generator) {
        super(m, man, true);
        this.genModel = genModel;
        this.generator = generator;
    }

    public void handleType(de.fhdw.wtf.common.ast.type.Type c) throws TaskException {
        c.accept((TypeVisitorException)new TypeGenerator());
    }

    public void finalizeTask() throws TaskException {
        try {
            Type anythingType = this.generator.getClassFacade().getTypeManager().getTypeforName("generated.sums.Anything");
            UserType persistentListType = this.generator.createClass(PersistentList.class.getName(), false, false);
            this.generator.createSpecialisation(anythingType.getId(), persistentListType.getId());
            this.generator.createUnidirectionalAssociation("links", false, false, persistentListType.getId(), anythingType.getId());
            UserType persistentMapType = this.generator.createClass(PersistentMap.class.getName(), false, false);
            this.generator.createSpecialisation(anythingType.getId(), persistentMapType.getId());
            this.generator.createMapAssociation("links", false, persistentMapType.getId(), anythingType.getId(), anythingType.getId());
        }
        catch (PersistenceException e) {
            throw new TaskException((Exception)((Object)e));
        }
    }

    public void beginTask() throws TaskException {
    }

    private class CompositeTypeGenerator
    implements CompositeTypeVisitorException<TaskException> {
        private final GenType genType;

        CompositeTypeGenerator(GenType genType) {
            this.genType = genType;
        }

        public void handle(ListType list) {
        }

        public void handle(MapType map) {
        }

        public void handle(ProductType product) throws TaskException {
            try {
                UserType newClass = TypeGenerationTask.this.generator.createClass(this.genType.getFullyQualifiedTypeName(), false, false);
                product.setTypeId((DatabaseIDState)new DatabaseIDSetState(newClass.getId()));
            }
            catch (PersistenceException e) {
                throw new TaskException((Exception)((Object)e));
            }
        }

        public void handle(SumType sum) throws TaskException {
            try {
                UserType newClass = TypeGenerationTask.this.generator.createClass(this.genType.getFullyQualifiedTypeName(), true, false);
                sum.setTypeId((DatabaseIDState)new DatabaseIDSetState(newClass.getId()));
            }
            catch (PersistenceException e) {
                throw new TaskException((Exception)((Object)e));
            }
        }

        public void handle(ThrownType thrownType) throws TaskException {
        }
    }

    private class ClassTypeGenerator
    implements GenClassVisitorException<TaskException> {
        private final ClassType clazz;

        ClassTypeGenerator(ClassType clazz) {
            this.clazz = clazz;
        }

        @Override
        public void handle(GenPrimitiveClass primitiveClass) {
        }

        @Override
        public void handle(GenInterfaceClass interfaceClass) throws TaskException {
            final ClassTypeGenerator gcv = this;
            interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                @Override
                public void handle(GenExternalInterfaceClass iface) {
                }

                @Override
                public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                    gcv.handle(interfaceWithImplClass.getClassRepresentation());
                }

                @Override
                public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
                    try {
                        UserType newClass = TypeGenerationTask.this.generator.createClass(simpleInterface.getFullyQualifiedTypeName(), false, ClassTypeGenerator.this.clazz.isService());
                        ClassTypeGenerator.this.clazz.setTypeId((DatabaseIDState)new DatabaseIDSetState(newClass.getId()));
                    }
                    catch (PersistenceException e) {
                        throw new TaskException((Exception)((Object)e));
                    }
                }
            });
        }

        @Override
        public void handle(GenClassClass classClass) throws TaskException {
            try {
                UserType newClass = TypeGenerationTask.this.generator.createClass(classClass.getFullyQualifiedTypeName(), false, this.clazz.isService());
                this.clazz.setTypeId((DatabaseIDState)new DatabaseIDSetState(newClass.getId()));
            }
            catch (PersistenceException e) {
                throw new TaskException((Exception)((Object)e));
            }
        }
    }

    private class AtomicTypeGenerator
    implements AtomicTypeVisitorException<TaskException> {
        private AtomicTypeGenerator() {
        }

        public void handle(BaseType baseType) throws TaskException {
            if (baseType.getTypeName().toString().equals("String")) {
                baseType.setTypeId((DatabaseIDState)new DatabaseIDSetState(1L));
            } else if (baseType.getTypeName().toString().equals("Integer")) {
                baseType.setTypeId((DatabaseIDState)new DatabaseIDSetState(2L));
            } else {
                throw new TaskException("Unknown base type: " + baseType.getTypeName());
            }
        }

        public void handle(ClassType clazz) throws TaskException {
            GenClass genType = TypeGenerationTask.this.genModel.getJavaClassForWTFClass((de.fhdw.wtf.common.ast.type.Type)clazz);
            if (genType == null) {
                throw new TaskException("TypeGenerationTask: No GenerationModel type for " + clazz.getTypeString());
            }
            genType.accept(new ClassTypeGenerator(clazz));
        }
    }

    private class TypeGenerator
    implements TypeVisitorException<TaskException> {
        private TypeGenerator() {
        }

        public void handle(AtomicType s) throws TaskException {
            s.accept((AtomicTypeVisitorException)new AtomicTypeGenerator());
        }

        public void handle(CompositeType c) throws TaskException {
            GenType genType = TypeGenerationTask.this.genModel.getGenTypeForType((de.fhdw.wtf.common.ast.type.Type)c);
            c.accept((CompositeTypeVisitorException)new CompositeTypeGenerator(genType));
        }

        public void handle(TypeProxy typeProxy) throws TaskException {
            throw new TaskException("TypeProxy found in TypeGenerationTask");
        }
    }
}

