package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;

/**
 * This visitor handles all GenOperationState-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenOperationStateVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenSimpleOperationState-type.
	 * 
	 * @param s
	 *            GenSimpleOperationState to handle.
	 * @return Value of type X
	 */
	X handle(GenSimpleOperationState s);
	
	/**
	 * Handle method for objects of GenFullParsedOperationState-type.
	 * 
	 * @param s
	 *            GenFullParsedOperationState to handle.
	 * @return Value of type X
	 */
	X handle(GenFullParsedOperationState s);
	
}
