package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.util.List;
import java.util.Vector;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;

/**
 * Generates the FactoryClass for every concrete class of the wtf model.
 */
public class FactoryTransformer extends SimpleGeneratorModelWalkerTask {
	
	private static final String DEFAULT_PARAMETER_VALUE = "null";
	private final GenClassClass userObjectFactory;
	
	/**
	 * Creates a new {@link FactoryTransformer}. Initializes the UserObjectFactory class as superclass<br>
	 * for all Factorys
	 * 
	 * @param taskmanager
	 * @param javaGeneratorModel
	 * @param inheritanceTransformer
	 */
	public FactoryTransformer(final TaskExecutor taskmanager,
			final GeneratorModel javaGeneratorModel,
			final DependencyTask inheritanceTransformer) {
		super(taskmanager, javaGeneratorModel);
		final GenPackage packag = GenUnqualifiedPackage.create("de");
		final GenPackage packag1 = packag.addName("fhdw");
		final GenPackage packag2 = packag1.addName("wtf");
		final GenPackage packag3 = packag2.addName("context");
		final GenPackage packag4 = packag3.addName("model");
		final GenUserClass userClass =
				GenUserClass.create(
						"UserObjectFactory",
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						null,
						packag4,
						GenComment.create(""),
						"");
		this.userObjectFactory = userClass;
		
		try {
			this.addDependency(inheritanceTransformer);
		} catch (final CyclicDependencyException e) {
			// should not happen
			e.printStackTrace();
			throw new Error("Dependency tasks are cyclic in FactoryTransformer.");
		}
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		// nothing to do
	}
	
	@Override
	public void handleClassClass(final GenClassClass cc) throws TaskException {
		if (!cc.getModifieres().contains(GenClassModifier.ABSTRACT)
				&& (cc.getFullyQualifiedTypeName().startsWith("generated.model.") || cc.getFullyQualifiedTypeName()
						.startsWith("generated.products."))) {
			FactoryTransformer.this.generateFactory(cc, cc);
		}
	}
	
	/**
	 * Creates the Factory for the current {@link GenInterfaceWithClassImplClass} with its createSpecificUserType
	 * operation.
	 */
	@Override
	public void handleInterfaceClass(final GenInterfaceClass ic) throws TaskException {
		ic.accept(new GenInterfaceClassVisitorException<TaskException>() {
			
			@Override
			public void handle(final GenSimpleInterfaceClass simpleInterface) throws TaskException {
				// nothing to do
			}
			
			@Override
			public void handle(final GenInterfaceWithClassImplClass iwc) throws TaskException {
				final GenClassClass cc = iwc.getClassRepresentation();
				if (!cc.getModifieres().contains(GenClassModifier.ABSTRACT)
						&& cc.getFullyQualifiedTypeName().startsWith("generated.model.")) {
					FactoryTransformer.this.generateFactory(iwc, iwc.getClassRepresentation());
				}
			}
			
			@Override
			public void handle(final GenExternalInterfaceClass iface) {
				// nothing to do
			}
		});
	}
	
	/**
	 * Creates the Factory for some class.
	 * 
	 * @param iface
	 *            The interface class.
	 * @param impl
	 *            The implementation class. May be equal to {@link iface}.
	 */
	private void generateFactory(final GenClass iface, final GenClassClass impl) {
		final GenUserClass factory =
				GenUserClass.create(
						iface.getName() + "Factory",
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						this.userObjectFactory,
						PackageConstants.FACTORY_PACKAGE,
						GenComment.createFromPlainText("Comment", false),
						"");
		final List<GenParameter> parameters = new Vector<>();
		parameters.add(GenParameter.create(
				OperationAttributeTransformer.LOAD_CONSTRUCTOR_PARAM_NAME,
				GenExternalClassClass.getInstance(OperationAttributeTransformer.LOAD_CONSTRUCTOR_PARAM_TYPE)));
		final GenJavaOperation createSpecificUserType =
				GenJavaOperation.create(
						"createSpecificUserType",
						GenVisibility.PROTECTED,
						parameters,
						new Vector<GenException>(),
						"return new " + impl.getFullyQualifiedTypeNameWithGenericArguments() + "("
								+ OperationAttributeTransformer.LOAD_CONSTRUCTOR_PARAM_NAME + ");",
						GenExternalInterfaceClass.getInstance("de.fhdw.wtf.context.model.IAnyType"),
						new Vector<GenOperationModifier>(),
						GenComment.create("@Override"));
		factory.addOperation(createSpecificUserType);
		// factory.getImports().add(GenAnyType.getInstance());
		this.getGeneratorModel().addNonAstClass(factory);
	}
	
	@Override
	public String toString() {
		return "Modelclass factory generation";
	}
	
	@Override
	public void handleOperation(final GenOperation o) throws TaskException {
		// nothing to do
	}
}
