package de.fhdw.wtf.generator.database.tasks;

import java.util.Iterator;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.exception.generation.NoTypeIdSetException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.database.generation.InitialGenerator;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;

/**
 * The {@link TypeGenerationService} puts all specializations of the Model (AST) into the database.
 * 
 */
public class SpecializationGenerationTask extends SimpleWalkerTaskForTypes {
	
	/**
	 * Creates a {@link SpecializationGenerationTask}.
	 * 
	 * @param m
	 *            The associated model.
	 * @param man
	 *            The task manager to use.
	 * @param generator
	 *            The generator to use.
	 */
	public SpecializationGenerationTask(final Model m, final TaskExecutor man, final InitialGenerator generator) {
		super(m, man);
		this.generator = generator;
	}
	
	/**
	 * The generator to use.
	 */
	private final InitialGenerator generator;
	
	@Override
	public void handleType(final Type c) throws TaskException {
		final Iterator<Type> i = c.getSuperTypes().iterator();
		while (i.hasNext()) {
			final Type current = i.next();
			Type superType;
			try {
				superType = HelperUtils.getReferencedType(current);
				this.generator.createSpecialisation(superType.getTypeId().getId(), c.getTypeId().getId());
				this.generator.getClassFacade().finalizeSpecialization();
			} catch (final PersistenceException | NoTypeIdSetException e) {
				throw new TaskException(e.getMessage());
			}
		}
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		try {
			this.generator.getClassFacade().finalizeSpecialization();
		} catch (final PersistenceException e) {
			throw new TaskException(e);
		}
	}
	
	@Override
	public void beginTask() throws TaskException {
		// Nothing
	}
}
