package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Name;
import de.fhdw.wtf.common.ast.QualifiedName;
import de.fhdw.wtf.common.ast.UnqualifiedName;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.ByNameState;
import de.fhdw.wtf.common.ast.type.ByReferenceState;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.InvalidState;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.NameReturnVisitor;
import de.fhdw.wtf.common.ast.visitor.TypeProxyStateVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturn;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenQualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;

public final class UtilTransformer {
	
	private final GeneratorModel generatorModel;
	
	private static final String GEN_PACKAGE_PREFIX_FIRST = "generated";
	private static final String GEN_PACKAGE_PREFIX_SECOND = "model";
	
	private UtilTransformer(final GeneratorModel generatorModel) {
		this.generatorModel = generatorModel;
	}
	
	public static UtilTransformer create(final GeneratorModel generatorModel) {
		return new UtilTransformer(generatorModel);
	}
	
	/**
	 * Returns an AST-Type that is no {@link TypeProxy} and represents a Prototype. If the given type is a TypeProxy,
	 * this method extracts the contained Type. Furthermore if the type is a {@link CompositeType} it gets the Prototype
	 * of the given type.
	 * 
	 * @param type
	 *            The Type to get an Prototype-representation for.
	 * @return {@link Type}
	 */
	public static Type getTypeProxyFreePrototype(final Type type) {
		final Type noTypeProxyType = UtilTransformer.getTypeOfPossibleTypeProxy(type);
		return UtilTransformer.getPrototype(noTypeProxyType);
	}
	
	/**
	 * Returns the Prototype for a given {@link Type}.
	 * 
	 * @param type
	 *            The Type to get the Prototype for.
	 * @return {@link Type}
	 */
	private static Type getPrototype(final Type type) {
		return type.accept(new TypeVisitorReturn<Type>() {
			
			@Override
			public Type handle(final AtomicType atomicType) {
				return atomicType;
			}
			
			@Override
			public Type handle(final CompositeType compositeType) {
				return compositeType.accept(new CompositeTypeVisitorReturn<Type>() {
					
					@Override
					public Type handle(final ListType list) {
						return list.getPrototype();
					}
					
					@Override
					public Type handle(final MapType map) {
						return map.getPrototype();
					}
					
					@Override
					public Type handle(final ProductType product) {
						return product.getPrototype();
					}
					
					@Override
					public Type handle(final SumType sum) {
						return sum.getPrototype();
					}
					
					@Override
					public Type handle(final ThrownType thrownType) {
						return thrownType.getPrototype();
					}
				});
			}
			
			@Override
			public Type handle(final TypeProxy typeProxy) {
				return UtilTransformer.getTypeOfPossibleTypeProxy(typeProxy);
			}
		});
	}
	
	/**
	 * Returns the {@link Type}. If the type is a {@link TypeProxy} and has the state {@link ByReferenceState}, it will
	 * return the targetType. If the type is a {@link TypeProxy} and has the state {@link ByNameState} or
	 * {@link InvalidState} it will return null.
	 * 
	 * @param type
	 * @return {@link Type}
	 */
	private static Type getTypeOfPossibleTypeProxy(final Type type) {
		return type.accept(new TypeVisitorReturn<Type>() {
			
			@Override
			public Type handle(final AtomicType s) {
				return s;
			}
			
			@Override
			public Type handle(final CompositeType c) {
				return c;
			}
			
			@Override
			public Type handle(final TypeProxy s) {
				return getTypeProxyTarget(s);
			}
		});
	}
	
	/**
	 * Returns the referenced type by typeProxy, if typeProxy´s state is not of type {@link ByReferenceState} null will
	 * be returned.
	 * 
	 * @param typeProxy
	 *            typeProxy
	 * @return {@link Type}
	 */
	private static Type getTypeProxyTarget(final TypeProxy typeProxy) {
		return typeProxy.getState().accept(new TypeProxyStateVisitorReturn<Type>() {
			
			@Override
			public Type handle(final ByNameState byName) {
				return null;
			}
			
			@Override
			public Type handle(final InvalidState invalidTypeReference) {
				return null;
			}
			
			@Override
			public Type handle(final ByReferenceState byType) {
				return byType.getTarget();
			}
		});
	}
	
	/**
	 * Sets {@link #classPath} and stores the current package name to the {@link #context}.
	 * 
	 * @param name
	 *            Name of the current class
	 * @return {@link GenPackage}
	 */
	public GenPackage getPackage(final Name name) {
		final GenPackage resultFirst = GenUnqualifiedPackage.create(GEN_PACKAGE_PREFIX_FIRST);
		final GenPackage result = resultFirst.addName(GEN_PACKAGE_PREFIX_SECOND);
		return result.addPackage(this.getRestPackage(name));
	}
	
	/**
	 * Returns the {@link GenPackage} of <code>name</code>.
	 * 
	 * @param name
	 *            the name that will be checked
	 * @return {@link GenPackage}
	 */
	private GenPackage getRestPackage(final Name name) {
		return name.visit(new NameReturnVisitor<GenPackage>() {
			@Override
			public GenPackage handle(final QualifiedName qualifiedName) {
				final GenUnqualifiedPackage first = GenUnqualifiedPackage.create(qualifiedName.getFirst().toString());
				return qualifiedName.getRest().visit(new NameReturnVisitor<GenPackage>() {
					@Override
					public GenPackage handle(final QualifiedName qualifiedName2) {
						final GenPackage rest = UtilTransformer.this.getRestPackage(qualifiedName2);
						return GenQualifiedPackage.create(first, rest);
					}
					
					@Override
					public GenPackage handle(final UnqualifiedName unqualifiedName) {
						return first;
					}
				});
			}
			
			@Override
			public GenPackage handle(final UnqualifiedName unqualifiedName) {
				return GenUnqualifiedPackage.create(unqualifiedName.toString());
			}
		});
	}
	
	/**
	 * Projections.
	 */
	public GeneratorModel getGeneratorModel() {
		return this.generatorModel;
	}
}
