package de.fhdw.wtf.generator.java.generatorModel;

import java.util.List;

import de.fhdw.wtf.generator.java.visitor.GenOperationVisitorReturn;

public final class GenAspectOperation extends GenOperation {
	
	private final GenClass owner;
	
	private GenAspectOperation(final String name,
			final List<GenParameter> parameters,
			final GenOperationState state,
			final GenClass owner) {
		super(name, parameters, state);
		this.owner = owner;
	}
	
	public static GenAspectOperation create(final String name,
			final List<GenParameter> parameters,
			final GenOperationState state,
			final GenClass owner) {
		return new GenAspectOperation(name, parameters, state, owner);
	}
	
	public GenClass getOwner() {
		return this.owner;
	}
	
	@Override
	public <T> T accept(final GenOperationVisitorReturn<T> visitor) {
		return visitor.handleAspectOperation(this);
	}
}
