package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;
import java.util.Vector;

import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;

/**
 * A primitive class represents an already in wtf-sources existing class for a primitive/base type.
 */
public abstract class GenPrimitiveClass extends GenClass {
	
	/**
	 * The type this class is an instance of.
	 */
	private final GenPrimitiveType instanceOf;
	/**
	 * The operetions of the primitive class.
	 */
	private static final Collection<GenJavaOperation> OPERATIONS = new Vector<>();
	/**
	 * The interfaces the primitive class implements.
	 */
	private static final Collection<GenInterfaceClass> IMPLEMENT = new Vector<>();
	/**
	 * The package of the primitive class.
	 */
	private static final GenPackage PACKAG = GenQualifiedPackage.create(
			GenUnqualifiedPackage.create("de"),
			GenQualifiedPackage.create(
					GenUnqualifiedPackage.create("fhdw"),
					GenQualifiedPackage.create(
							GenUnqualifiedPackage.create("wtf"),
							GenQualifiedPackage.create(
									GenUnqualifiedPackage.create("context"),
									GenUnqualifiedPackage.create("model")))));
	/**
	 * The comment that describes the primitive class.
	 */
	private static final GenComment COMMENT = GenComment.create("");
	/**
	 * The additional code for primitive classes.
	 */
	private static final String NON_GENERATED_PART = "";
	
	/**
	 * Instantiates a new GenPrimitiveClass.
	 * 
	 * @param instanceOf
	 *            The type this class is an instance of.
	 */
	protected GenPrimitiveClass(final GenPrimitiveType instanceOf) {
		super(instanceOf.getName(), OPERATIONS, IMPLEMENT, PACKAG, COMMENT, NON_GENERATED_PART);
		this.instanceOf = instanceOf;
	}
	
	/**
	 * Returns the type this class is an instance of.
	 * 
	 * @return GenPrimitiveType
	 */
	public GenPrimitiveType getType() {
		return this.instanceOf;
	}
	
	@Override
	public void accept(final GenClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends Exception> void accept(final GenClassVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
}
