package de.fhdw.wtf.generator.java.generatorModel;

/**
 * A {@link GenUnqualifiedPackage} can represent a part of a {@link GenQualifiedPackage} as it represents a part between
 * two dots.
 */
public final class GenUnqualifiedPackage extends GenPackage {
	
	/**
	 * The unqualified package name.
	 */
	private final String unqualifiedName;
	
	/**
	 * Instantiates a new {@link GenUnqualifiedPackage}.
	 * 
	 * @param name
	 *            The partial name of this package.
	 */
	private GenUnqualifiedPackage(final String name) {
		super();
		this.unqualifiedName = name;
	}
	
	/**
	 * Returns a new instance of {@link GenUnqualifiedPackage} and copies all attribute-values from
	 * <code>packageToCopy</code>.
	 * 
	 * @param packageToCopy
	 *            The {@link GenUnqualifiedPackage} to copy attribute-values from.
	 */
	private GenUnqualifiedPackage(final GenUnqualifiedPackage packageToCopy) {
		super();
		this.unqualifiedName = packageToCopy.getName();
	}
	
	/**
	 * Creates a new {@link GenUnqualifiedPackage} with the given name.
	 * 
	 * @param name
	 *            The name of the {@link GenUnqualifiedPackage}.
	 * @return {@link GenUnqualifiedPackage}
	 */
	public static GenUnqualifiedPackage create(final String name) {
		return new GenUnqualifiedPackage(name);
	}
	
	@Override
	public GenPackage addName(final String name) {
		final GenUnqualifiedPackage rest = GenUnqualifiedPackage.create(name);
		final GenQualifiedPackage newName = GenQualifiedPackage.create(this, rest);
		return newName;
	}
	
	@Override
	public GenPackage addPackage(final GenPackage packag) {
		final GenPackage result = GenQualifiedPackage.create(this, packag);
		return result;
	}
	
	/**
	 * Returns the name of this {@link GenUnqualifiedPackage}.
	 * 
	 * @return String
	 */
	public String getName() {
		return this.unqualifiedName;
	}
	
	@Override
	public String toString() {
		return this.getName();
	}
	
	@Override
	public GenPackage copy() {
		return new GenUnqualifiedPackage(this);
	}
	
}
