package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.AttributeModifier;
import de.fhdw.wtf.common.ast.AttributeModifierFindable;
import de.fhdw.wtf.common.ast.AttributeModifierMutable;
import de.fhdw.wtf.common.ast.AttributeModifierPrior;
import de.fhdw.wtf.common.ast.AttributeModifierSymmetric;
import de.fhdw.wtf.common.ast.AttributeModifierTransient;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.Operation;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductElementType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.AttributModifierVisitor;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.OperationModifierVisitor;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAttributeModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.exception.NoAttributeAllowedInInterface;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;

public final class OperationAttributeTransformer extends SimpleWalkerTaskForTypes {
	
	private final GeneratorModel generatorModel;
	
	/**
	 * String that represents the default method implementation.
	 */
	private static final String DEFAULT_METHOD = "//TODO implement";
	
	/**
	 * String that represents the name of the parameter of a load constructor.
	 */
	public static final String LOAD_CONSTRUCTOR_PARAM_NAME = "userObject";
	
	/**
	 * String that represents the type of the parameter of a load constructor.
	 */
	public static final String LOAD_CONSTRUCTOR_PARAM_TYPE = "de.fhdw.wtf.persistence.meta.UserObject";
	
	/**
	 * String that represents the default load constructor implementation.
	 */
	private static final String DEFAULT_LOAD_CONSTRUCTOR = "super(" + LOAD_CONSTRUCTOR_PARAM_NAME + ");";
	
	/**
	 * String that represents the default comment for an operation.
	 */
	private static final String DEFAULT_OPERATION_COMMENT = "/** \n \t * TODO Comment Op \n\t */";
	
	/**
	 * The default comment for constructor loading object from database.
	 */
	private static final String DEFAULT_LOAD_CONSTRUCTOR_COMMENT =
			"/** \n \t * Loads object from database.\n \t * @param userObject The underlying user object.\n\t */";
	
	/**
	 * String that represents a java code line end.
	 */
	private static final char JAVA_LINE_END = ';';
	
	/**
	 * String that represents the default commit for a constructor of a product.
	 */
	private static final String DEFAULT_PRODUCT_CONSTRUCTOR_COMMENT = "Create a anonym product.";
	
	/**
	 * String that represents an equal Symbol.
	 */
	private static final String EQUAL_SYMBOL = "=";
	
	/**
	 * String that represents a this.
	 */
	private static final String THIS_POINT = "this.";
	
	/**
	 * String that represents a tab.
	 */
	private static final String TAB = "\t";
	
	/**
	 * String that represents a new line.
	 */
	private static final String NEW_LINE = "\n";
	
	private OperationAttributeTransformer(final Model m,
			final TaskExecutor taskmanager,
			final GeneratorModel generatorModel,
			final TypeTransformer typeTransformer) {
		super(m, taskmanager, true);
		this.generatorModel = generatorModel;
		
		try {
			this.addDependency(typeTransformer);
		} catch (final CyclicDependencyException e) {
			// should not happen
			e.printStackTrace();
			throw new Error("Dependency tasks are cyclic in OperationAttributeTransformer.");
		}
	}
	
	public static OperationAttributeTransformer create(final Model m,
			final TaskExecutor taskmanager,
			final GeneratorModel generatorModel,
			final TypeTransformer typeTransformer) {
		return new OperationAttributeTransformer(m, taskmanager, generatorModel, typeTransformer);
	}
	
	public GeneratorModel getGeneratorModel() {
		return this.generatorModel;
	}
	
	@Override
	public void handleType(final Type c) throws TaskException {
		c.accept(new TypeVisitorException<TaskException>() {
			
			@Override
			public void handle(final AtomicType atomicType) throws TaskException {
				atomicType.accept(new AtomicTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final BaseType baseType) {
						// BaseTypes are not generated
					}
					
					@Override
					public void handle(final ClassType clazz) throws TaskException {
						final Iterator<Attribute> attributeIt = clazz.getAttributes().iterator();
						while (attributeIt.hasNext()) {
							final Attribute current = attributeIt.next();
							OperationAttributeTransformer.this.handleAttribute(current, clazz);
						}
						
						final Iterator<Operation> operationIt = clazz.getOperations().iterator();
						while (operationIt.hasNext()) {
							final Operation current = operationIt.next();
							OperationAttributeTransformer.this.handleOperation(current, clazz);
						}
						final GenClass genOwner =
								OperationAttributeTransformer.this.getGeneratorModel().getClassMapping().get(clazz);
						genOwner.accept(new GenClassVisitorException<TaskException>() {
							
							@Override
							public void handle(final GenClassClass classClass) throws TaskException {
								OperationAttributeTransformer.this.createLoadConstructor(classClass);
							}
							
							@Override
							public void handle(final GenInterfaceClass interfaceClass) throws TaskException {
								interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>() {
									
									@Override
									public void handle(final GenSimpleInterfaceClass simpleInterface)
											throws TaskException {
										// Nothing to do.
										// TODO Really nothing to do?
									}
									
									@Override
									public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass)
											throws TaskException {
										OperationAttributeTransformer.this.createLoadConstructor(interfaceWithImplClass
												.getImplementor());
									}
									
									@Override
									public void handle(final GenExternalInterfaceClass iface) throws TaskException {
										// Nothing to do.
									}
									
								});
							}
							
							@Override
							public void handle(final GenPrimitiveClass primitiveClass) throws TaskException {
								OperationAttributeTransformer.this.createLoadConstructor(primitiveClass
										.getImplementor());
							}
						});
					}
				});
			}
			
			@Override
			public void handle(final CompositeType compositeType) throws TaskException {
				compositeType.accept(new CompositeTypeVisitorException<TaskException>() {
					
					@Override
					public void handle(final SumType sum) {
						// Sums do not have operations other than accept-Methods that are generated in
						// VisitorTypeTransformer
					}
					
					@Override
					public void handle(final ProductType product) throws TaskException {
						final GenClassClass prod =
								(GenClassClass) OperationAttributeTransformer.this.getGeneratorModel()
										.getGenTypeForType(product);
						if (product.equals(product.getAbstractPrototype())) {
							// only add attributes to Products if they are the AbstractProductPrototype
							OperationAttributeTransformer.this.handleProductAttributes(product, prod);
						} else {
							// only add getters and setters to Products if they are not the AbstractProductPrototype
							OperationAttributeTransformer.this.generateProductsGettersAndSetters(product, prod);
						}
						// always create load constructor, regardless whether product type is or is not an abstract
						// prototype or not
						OperationAttributeTransformer.this.createLoadConstructor(prod);
					}
					
					@Override
					public void handle(final MapType map) {
						// Maps are not generated
					}
					
					@Override
					public void handle(final ListType list) {
						// Lists are not generated
					}
					
					@Override
					public void handle(final ThrownType thrownType) {
						// ThrownTypes are not generated
					}
				});
			}
			
			@Override
			public void handle(final TypeProxy typeProxy) throws TaskException {
				// No need to handle TypeProxy
				
			}
		});
	}
	
	/**
	 * Creates a special load constructor and adds it to a non-interface class.
	 * 
	 * @param classClass
	 *            The GenClassClass object to add the constructor to.
	 */
	private void createLoadConstructor(final GenClassClass classClass) {
		// generate special constructor for loading object from database
		final GenComment comment = GenComment.create(DEFAULT_LOAD_CONSTRUCTOR_COMMENT);
		final GenType returnTyp = classClass;
		final String method = DEFAULT_LOAD_CONSTRUCTOR;
		final List<GenParameter> parameters = new Vector<>();
		parameters.add(GenParameter.create(
				LOAD_CONSTRUCTOR_PARAM_NAME,
				GenExternalClassClass.getInstance(LOAD_CONSTRUCTOR_PARAM_TYPE)));
		classClass.addConstructor(GenJavaOperation.create(
				"",
				GenVisibility.PUBLIC,
				parameters,
				new Vector<GenException>(),
				method,
				returnTyp,
				new Vector<GenOperationModifier>(),
				comment));
	}
	
	public void handleAttribute(final Attribute a, final ClassType owner) throws TaskException {
		final String name = a.getName();
		final GenType attrType = this.getGeneratorModel().getGenTypeForType(a.getAttrType());
		final Collection<GenAttributeModifier> modifiers = this.handleAttributModifier(a, owner);
		final GenJavaAttribute result = GenJavaAttribute.create(name, GenVisibility.PRIVATE, attrType, modifiers);
		this.getGeneratorModel().getClassMapping().get(owner)
				.accept(new HandleAttributeGetOwnerGenClassVisitorException(result, a));
	}
	
	private final class HandleAttributeGetOwnerGenClassVisitorException implements
			GenClassVisitorException<TaskException> {
		private final GenJavaAttribute result;
		private final Attribute a;
		
		private HandleAttributeGetOwnerGenClassVisitorException(final GenJavaAttribute result, final Attribute a) {
			this.result = result;
			this.a = a;
		}
		
		@Override
		public void handle(final GenClassClass classClass) throws TaskException {
			classClass.getAttributes().add(this.result);
			
		}
		
		@Override
		public void handle(final GenInterfaceClass interfaceClass) throws TaskException {
			interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>() {
				
				@Override
				public void handle(final GenSimpleInterfaceClass simpleInterface) throws TaskException {
					throw NoAttributeAllowedInInterface.create();
				}
				
				@Override
				public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
					HandleAttributeGetOwnerGenClassVisitorException.this.handle(interfaceWithImplClass
							.getClassRepresentation());
				}
				
				@Override
				public void handle(final GenExternalInterfaceClass iface) throws TaskException {
					throw NoAttributeAllowedInInterface.create();
				}
			});
		}
		
		@Override
		public void handle(final GenPrimitiveClass primitiveClass) throws NoAttributeAllowedInInterface {
			// nothing to do
		}
	}
	
	/**
	 * Handles the occourence of {@link AttributeModifier}.
	 *
	 * @param a
	 * @param owner
	 * @return List of {@link AttributeModifier}
	 */
	private Vector<GenAttributeModifier> handleAttributModifier(final Attribute a, final ClassType owner) {
		final Vector<GenAttributeModifier> modifier = new Vector<>();
		final GenAttributeModifier finalAttr = GenAttributeModifier.FINAL;
		modifier.add(finalAttr);
		final Iterator<AttributeModifier> i = a.getModifiers().iterator();
		while (i.hasNext()) {
			final AttributeModifier current = i.next();
			current.accept(new AttributModifierVisitor() {
				@Override
				public boolean handle(final AttributeModifierMutable mutable) {
					return modifier.remove(finalAttr);
				}
				
				@Override
				public boolean handle(final AttributeModifierFindable findable) {
					return true;
				}
				
				@Override
				public boolean handle(final AttributeModifierTransient tranzient) {
					return modifier.add(GenAttributeModifier.TRANSIENT);
				}
				
				@Override
				public boolean handle(final AttributeModifierPrior prior) {
					// Final Attribute already in the list
					return true;
				}
				
				@Override
				public boolean handle(final AttributeModifierSymmetric symmetric) {
					return OperationAttributeTransformer.this.handleSymmetricAttributeModifier(a, symmetric, owner);
				}
			});
		}
		modifier.remove(finalAttr);
		return modifier;
	}
	
	private boolean handleSymmetricAttributeModifier(final Attribute a,
			final AttributeModifierSymmetric modifier,
			final ClassType owner) {
		try {
			final Vector<ClassType> targetClasses = this.getTargetClasses(a.getAttrType());
			for (final ClassType targetClass : targetClasses) {
				this.addInverseGetterTo(a, targetClass, modifier, owner);
			}
		} catch (final GenTypeNotReferencedException e) {
			e.printStackTrace();
		}
		return false;
	}
	
	private void addInverseGetterTo(final Attribute attribute,
			final ClassType targetClass,
			final AttributeModifierSymmetric modifier,
			final ClassType owner) {
		final GenClass symmetricRelationAccessClass = this.getSymmetricRelationAccessClassOfClass(owner, targetClass);
		final String targetClassName = targetClass.getName().getLastAddedName().toString().toLowerCase();
		final String inverseGetterIdentifier = modifier.getIdentifierToken().getIdentifier();
		
		final String targetString = "target";
		final String ownerString = "owner";
		
		GenType returnType;
		String superMethodName;
		Boolean isStarAssociation;
		
		// Entscheidung ob 0..1 oder * Assoziation
		if (attribute.getAttrType() instanceof CompositeType) { // *
			returnType = GenJavaUtilCollection.create(this.getGeneratorModel().getJavaClassForWTFClass(owner));
			superMethodName = "inverseGetCollection";
			isStarAssociation = true;
		} else {
			returnType = this.getGeneratorModel().getJavaClassForWTFClass(owner).getImplementor();
			superMethodName = "<" + returnType.getFullyQualifiedTypeNameWithGenericArguments() + ">inverseGet";
			isStarAssociation = false;
		}
		final Vector<GenParameter> registerSetterParameters = new Vector<>();
		// TODO final GenParameter ownerParameter0 = GenParameter.create("setter", target.getSetter());
		final GenParameter targetParameter0 =
				GenParameter.create(targetString, this.getGeneratorModel().getJavaClassForWTFClass(targetClass));
		// registerSetterParameters.add(ownerParameter0);
		registerSetterParameters.add(targetParameter0);
		final GenJavaOperation registerSetterMethod =
				GenJavaOperation.create(
						"registerSetter" + attribute.getName(),
						GenVisibility.PUBLIC,
						registerSetterParameters,
						new Vector<GenException>(),
						"",
						GenVoidType.getInstance(),
						new Vector<GenOperationModifier>(),
						GenComment.create(""));
		symmetricRelationAccessClass.addOperation(registerSetterMethod);
		
		// Bei 1 Assoziation set erstellen
		if (!isStarAssociation) {
			final Vector<GenParameter> parameters = new Vector<>();
			final GenParameter ownerParameter =
					GenParameter.create(ownerString, this.getGeneratorModel().getJavaClassForWTFClass(owner));
			final GenParameter targetParameter =
					GenParameter.create(targetString, this.getGeneratorModel().getJavaClassForWTFClass(targetClass));
			parameters.add(ownerParameter);
			parameters.add(targetParameter);
			final String methodContent = "//TODO methodContent wird noch implementiert";
			// TODO method
			final GenJavaOperation setMethod =
					GenJavaOperation.create(
							"set" + attribute.getName(),
							GenVisibility.PUBLIC,
							parameters,
							new Vector<GenException>(),
							methodContent,
							GenVoidType.getInstance(),
							new Vector<GenOperationModifier>(),
							GenComment.create(""));
			symmetricRelationAccessClass.addOperation(setMethod);
			
			// final Collection<GenAttributeModifier> genAttrModifier = null;
			// final GenJavaAttribute hashMap =
			// GenJavaAttribute.create(
			// "mapHALLO" + attribute.getName(),
			// GenVisibility.PRIVATE,
			// GenVoidType.getInstance(),
			// genAttrModifier);
			//
			// ((GenClassClass) symmetricRelationAccessClass).getAttributes().add(hashMap);
			
		} else {
			// TODO hier muss noch add und remove für * Assoziation implementiert werden
			final Vector<GenParameter> parameters1 = new Vector<>();
			final GenParameter ownerParameter1 =
					GenParameter.create(ownerString, this.getGeneratorModel().getJavaClassForWTFClass(owner));
			final GenParameter targetParameter1 =
					GenParameter.create(targetString, this.getGeneratorModel().getJavaClassForWTFClass(targetClass));
			parameters1.add(ownerParameter1);
			parameters1.add(targetParameter1);
			final String methodContentAdd = "//TODO methodContent wird noch implementiert.";
			// TODO method
			final GenJavaOperation addMethod =
					GenJavaOperation.create(
							"add" + attribute.getName(),
							GenVisibility.PUBLIC,
							parameters1,
							new Vector<GenException>(),
							methodContentAdd,
							GenVoidType.getInstance(),
							new Vector<GenOperationModifier>(),
							GenComment.create(""));
			
			final Vector<GenParameter> parameters2 = new Vector<>();
			final GenParameter ownerParameter2 =
					GenParameter.create(ownerString, this.getGeneratorModel().getJavaClassForWTFClass(owner));
			final GenParameter targetParameter2 =
					GenParameter.create(targetString, this.getGeneratorModel().getJavaClassForWTFClass(targetClass));
			parameters2.add(ownerParameter2);
			parameters2.add(targetParameter2);
			final String methodContentRemove = "//methodContent wird noch implementiert.";
			// TODO method.
			final GenJavaOperation removeMethod =
					GenJavaOperation.create(
							"remove" + attribute.getName(),
							GenVisibility.PUBLIC,
							parameters2,
							new Vector<GenException>(),
							methodContentRemove,
							GenVoidType.getInstance(),
							new Vector<GenOperationModifier>(),
							GenComment.create(""));
			symmetricRelationAccessClass.addOperation(removeMethod);
			symmetricRelationAccessClass.addOperation(addMethod);
		}
		
		// TODO: Use constants/config-file instead of literals
		final String associationName =
				"generated.model" + "." + owner.getName().toString().replace('>', '.') + "." + attribute.getName();
		final String methodContent =
				"return this." + superMethodName + "(" + targetClassName + ", \"" + associationName + "\");";
		
		final GenJavaOperation inverseGetter =
				GenJavaOperation.create(
						inverseGetterIdentifier,
						GenVisibility.PUBLIC,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						methodContent,
						returnType,
						new Vector<GenOperationModifier>(),
						GenComment.create(""));
		
		// final GenJavaOperation
		
		final GenClass genClass = this.getGeneratorModel().getJavaClassForWTFClass(targetClass);
		final GenClassClass genClassClass = genClass.getImplementor();
		final GenParameter newParam = GenParameter.create(targetClassName, genClassClass);
		inverseGetter.getParameters().add(newParam);
		
		symmetricRelationAccessClass.addOperation(inverseGetter);
	}
	
	private Vector<ClassType> getTargetClasses(final Type attrTypeOccurance) throws GenTypeNotReferencedException {
		final Vector<ClassType> targetTypes = new Vector<>();
		final Type attributeType = UtilTransformer.getTypeProxyFreePrototype(attrTypeOccurance);
		attributeType.accept(new TypeVisitorException<GenTypeNotReferencedException>() {
			
			@Override
			public void handle(final AtomicType s) throws GenTypeNotReferencedException {
				s.accept(new AtomicTypeVisitorException<GenTypeNotReferencedException>() {
					
					@Override
					public void handle(final BaseType baseType) throws GenTypeNotReferencedException {
						// NOthing
					}
					
					@Override
					public void handle(final ClassType clazz) throws GenTypeNotReferencedException {
						targetTypes.add(clazz);
					}
				});
			}
			
			@Override
			public void handle(final CompositeType c) throws GenTypeNotReferencedException {
				
				c.accept(new CompositeTypeVisitorException<GenTypeNotReferencedException>() {
					
					@Override
					public void handle(final MapType map) throws GenTypeNotReferencedException {
						targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(map.getOf()));
						
					}
					
					@Override
					public void handle(final ListType list) throws GenTypeNotReferencedException {
						targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(list.getOf()));
						
					}
					
					@Override
					public void handle(final ProductType product) throws GenTypeNotReferencedException {
						for (final ProductElementType factorTypeOccurance : product.getElements()) {
							targetTypes.addAll(OperationAttributeTransformer.this.getTargetClasses(factorTypeOccurance
									.getType()));
						}
					}
					
					@Override
					public void handle(final SumType sum) throws GenTypeNotReferencedException {
						for (final Type summandTypeOccurance : sum.getElements()) {
							targetTypes.addAll(OperationAttributeTransformer.this
									.getTargetClasses(summandTypeOccurance));
						}
					}
					
					@Override
					public void handle(final ThrownType thrownType) throws GenTypeNotReferencedException {
						// nothing to do
					}
				});
			}
			
			@Override
			public void handle(final TypeProxy s) throws GenTypeNotReferencedException {
				// nothing to do
			}
		});
		return targetTypes;
	}
	
	private GenClass getSymmetricRelationAccessClassOfClass(final ClassType ownerClass, final ClassType targetClass) {
		// Bsp.: A
		final String ownerClassName = ownerClass.getName().getLastAddedName() + "";
		
		// Bsp.: B
		final String targetClassName = targetClass.getName().getLastAddedName() + "";
		
		// Sortiere Klassen Lexikographisch
		final String[] strings = { ownerClassName, targetClassName };
		Arrays.sort(strings);
		
		// Name des Singletons der für die Relation verantwortlich ist, Bsp.: A_BSymmetricRelationAccess
		final String symmetricRelationAccessName = strings[0] + "_" + strings[1] + "SymmetricRelationAccess";
		
		for (final GenClass knownClass : this.getGeneratorModel().getClasses()) {
			if (knownClass.getName().equals(symmetricRelationAccessName)) {
				return knownClass;
			}
		}
		
		GenPackage superClassPackage = GenUnqualifiedPackage.create("de");
		superClassPackage = superClassPackage.addName("fhdw");
		superClassPackage = superClassPackage.addName("wtf");
		superClassPackage = superClassPackage.addName("context");
		superClassPackage = superClassPackage.addName("model");
		
		final GenUserClass symmetricRelationAccessSuperClass =
				GenUserClass.create(
						"SymmetricRelationAccess",
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						null,
						superClassPackage,
						GenComment.createFromPlainText("", false),
						"");
		
		GenPackage classPackage = GenUnqualifiedPackage.create("generated");
		classPackage = classPackage.addName("symmetry");
		
		final GenUserClass symmetricRelationAccessClass =
				GenUserClass.create(
						symmetricRelationAccessName,
						new Vector<GenJavaOperation>(),
						new Vector<GenInterfaceClass>(),
						new Vector<GenJavaAttribute>(),
						new Vector<GenClassModifier>(),
						new Vector<GenJavaOperation>(),
						symmetricRelationAccessSuperClass,
						classPackage,
						GenComment.createFromPlainText("", false),
						"");
		
		final Vector<GenAttributeModifier> instanceAttributeModifiers = new Vector<>();
		instanceAttributeModifiers.add(GenAttributeModifier.STATIC);
		final GenJavaAttribute instanceAttribute =
				GenJavaAttribute.create(
						"instance",
						GenVisibility.PRIVATE,
						symmetricRelationAccessClass,
						instanceAttributeModifiers);
		
		final Vector<GenOperationModifier> getInstanceModifiers = new Vector<>();
		getInstanceModifiers.add(GenOperationModifier.STATIC);
		final GenJavaOperation getInstanceOperation =
				GenJavaOperation.create(
						"getInstance",
						GenVisibility.PUBLIC,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"if(instance == null) instance = new " + symmetricRelationAccessName + "(); return instance;",
						symmetricRelationAccessClass,
						getInstanceModifiers,
						GenComment.create(""));
		
		final GenJavaOperation constructor =
				GenJavaOperation.createConstructor(
						symmetricRelationAccessClass,
						GenVisibility.PRIVATE,
						new Vector<GenParameter>(),
						new Vector<GenException>(),
						"",
						GenComment.create(""));
		
		symmetricRelationAccessClass.getAttributes().add(instanceAttribute);
		symmetricRelationAccessClass.addOperation(getInstanceOperation);
		symmetricRelationAccessClass.getConstructors().add(constructor);
		
		this.getGeneratorModel().addNonAstClass(symmetricRelationAccessClass);
		this.getGeneratorModel().addSymmetricManager(symmetricRelationAccessClass, ownerClass);
		this.getGeneratorModel().addSymmetricManager(symmetricRelationAccessClass, targetClass);
		return symmetricRelationAccessClass;
	}
	
	public void handleOperation(final Operation o, final ClassType owner) throws TaskException {
		final GenComment comment = GenComment.create(DEFAULT_OPERATION_COMMENT);
		final String name = o.getName();
		final Vector<GenOperationModifier> modifiers = this.getOperationModifiers(o);
		final Collection<GenException> exceptions = this.getGeneratorModel().getGenExceptionsForType(o.getReturnType());
		final GenType returnTyp = this.getGeneratorModel().getGenTypeForType(o.getReturnType());
		final String method =
				DEFAULT_METHOD + (returnTyp.getFullyQualifiedTypeName().equals("void") ? "" : "\n\t\treturn null;");
		final List<GenParameter> parameters = this.handleParameter(o.getParameters());
		final GenJavaOperation result =
				GenJavaOperation.create(
						name,
						GenVisibility.PUBLIC,
						parameters,
						exceptions,
						method,
						returnTyp,
						modifiers,
						comment);
		
		final GenClass genOwner = this.getGeneratorModel().getClassMapping().get(owner);
		genOwner.accept(new GenClassVisitor() {
			
			@Override
			public void handle(final GenPrimitiveClass primitiveClass) {
				// primitiveClass will not be generated, adding operation is useless
			}
			
			@Override
			public void handle(final GenInterfaceClass interfaceClass) {
				
				interfaceClass.accept(new GenInterfaceClassVisitor() {
					
					@Override
					public void handle(final GenInterfaceWithClassImplClass interfaceWithImplClass) {
						interfaceWithImplClass.addOperation(result);
						interfaceWithImplClass.getClassRepresentation().addOperation(result);
					}
					
					@Override
					public void handle(final GenSimpleInterfaceClass simpleInterface) {
						simpleInterface.addOperation(result);
					}
					
					@Override
					public void handle(final GenExternalInterfaceClass iface) {
						throw new Error("Operation " + o.getName() + " cannot be added to external interface "
								+ iface.getFullyQualifiedTypeName());
					}
				});
			}
			
			@Override
			public void handle(final GenClassClass classClass) {
				classClass.addOperation(result);
			}
		});
	}
	
	/**
	 * Returns a {@link Vector} with {@link GenOperationModifier} for the {@link Operation} <code>o</code>.
	 *
	 * @param o
	 *            o
	 * @return Vector<GenOperationModifier>
	 */
	private Vector<GenOperationModifier> getOperationModifiers(final Operation o) {
		final Vector<GenOperationModifier> result = new Vector<>();
		final Iterator<de.fhdw.wtf.common.ast.OperationModifier> i = o.getModifiers().iterator();
		while (i.hasNext()) {
			final de.fhdw.wtf.common.ast.OperationModifier current = i.next();
			current.accept(new OperationModifierVisitor() {
				@Override
				public boolean handle(final de.fhdw.wtf.common.ast.OperationModifier abstract1) {
					result.add(GenOperationModifier.ABSTRACT);
					return false;
				}
			});
		}
		return result;
	}
	
	/**
	 * TODO Janik / Tilmann soll das wirklich so?!
	 *
	 * @param o
	 * @return
	 * @throws TaskException
	 */
	protected List<GenParameter> handleParameter(final ProductType o) throws TaskException {
		final List<ProductElementType> elements = o.getElements();
		final Vector<GenParameter> result = new Vector<>();
		for (final ProductElementType productElement : elements) {
			final GenType paramType = this.getGeneratorModel().getGenTypeForType(productElement.getType());
			result.add(GenParameter.create(productElement.getName(), paramType));
		}
		return result;
	}
	
	// BEGIN PRODUCTS
	
	/**
	 * For each element of <code>product</code> this methods adds an <code>protected</code> attribute to the
	 * {@link GenClassClass} that represents the {@link ProductType}.
	 *
	 * @param product
	 *            given {@link ProductType} to add attributes for.
	 * @param prod
	 *            The underlying {@link GenClassClass} for the product passed.
	 * @throws TaskException
	 *             Thrown when the product or an element-Type is not referenced in the {@link GeneratorModel}.
	 */
	private void handleProductAttributes(final ProductType product, final GenClassClass prod) throws TaskException {
		final StringBuilder methodString = new StringBuilder();
		final List<GenParameter> parameters = new Vector<>();
		final Iterator<ProductElementType> i = product.getElements().iterator();
		while (i.hasNext()) {
			final ProductElementType element = i.next();
			final Collection<GenAttributeModifier> modifiers = new Vector<>();
			final GenType type = this.getGeneratorModel().getGenTypeForType(element.getType());
			final GenJavaAttribute currentAttr =
					GenJavaAttribute.create(element.getName(), GenVisibility.PROTECTED, type, modifiers);
			prod.getAttributes().add(currentAttr);
			
			final String methodStringInitialize =
					THIS_POINT + currentAttr.getName() + EQUAL_SYMBOL + currentAttr.getName() + JAVA_LINE_END;
			if (methodString.toString().equals("")) {
				methodString.append(methodStringInitialize);
			} else {
				methodString.append(NEW_LINE + TAB + TAB + methodStringInitialize);
			}
			final GenParameter parameter = GenParameter.create(currentAttr.getName(), currentAttr.getTyp());
			parameters.add(parameter);
		}
		// constructor
		final GenComment comment = GenComment.createFromPlainText(DEFAULT_PRODUCT_CONSTRUCTOR_COMMENT, true);
		final GenJavaOperation constructor =
				GenJavaOperation.createConstructor(
						prod,
						GenVisibility.PUBLIC,
						parameters,
						new Vector<GenException>(),
						methodString.toString(),
						comment);
		prod.getConstructors().add(constructor);
	}
	
	/**
	 * For each element of <code>product</code> this operation adds an getter and an setter to the {@link GenClassClass}
	 * that represents the {@link ProductType}. Furthermore this operation adds a constructor based on all attributes to
	 * the {@link GenClassClass}.
	 *
	 * @param product
	 *            given {@link ProductType} to generate getters, setters and a constructor for.
	 * @param prod
	 *            The underlying {@link GenClassClass} for the product passed.
	 * @throws TaskException
	 *             Thrown when the product or an element-Type is not referenced in the {@link GeneratorModel}.
	 */
	private void generateProductsGettersAndSetters(final ProductType product, final GenClassClass prod)
			throws TaskException {
		final Iterator<ProductElementType> i = product.getElements().iterator();
		BigInteger currentElementCount = BigInteger.ZERO;
		while (i.hasNext()) {
			currentElementCount = currentElementCount.add(BigInteger.ONE);
			final ProductElementType current = i.next();
			final String name = current.getName();
			final String capitalName = name.substring(0, 1).toUpperCase() + name.substring(1);
			final Collection<GenException> exceptions = new Vector<>();
			final GenType prodElementType = this.getGeneratorModel().getGenTypeForType(current.getType());
			final Collection<GenOperationModifier> operationModifier = new Vector<>();
			// getter
			final List<GenParameter> paramsGetter = new ArrayList<>();
			final String implementationGetter = "return this.p$" + currentElementCount.toString() + ";";
			prod.addOperation(GenJavaOperation.create(
					"get" + capitalName,
					GenVisibility.PUBLIC,
					paramsGetter,
					exceptions,
					implementationGetter,
					prodElementType,
					operationModifier,
					GenComment.createFromPlainText("", true)));
			// setter
			final List<GenParameter> paramsSetter = new ArrayList<>();
			final GenParameter setParam = GenParameter.create(name, prodElementType);
			paramsSetter.add(setParam);
			final String implementationSetter = "this.p$" + currentElementCount.toString() + " = " + name + ";";
			prod.addOperation(GenJavaOperation.create(
					"set" + capitalName,
					GenVisibility.PUBLIC,
					paramsSetter,
					exceptions,
					implementationSetter,
					GenVoidType.getInstance(),
					operationModifier,
					GenComment.createFromPlainText("", false)));
		}
	}
	
	// END PRODUCTS
	
	@Override
	public String toString() {
		return "Operation and Attribute generation";
	}
	
	@Override
	public void beginTask() throws TaskException {
		// Nothing
	}
	
	@Override
	public void finalizeTask() throws TaskException {
		// Nothing
	}
}
