package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;

public abstract class GenInterfaceClass extends GenClass {
	
	protected GenInterfaceClass(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		super(name, operations, implement, packag, comment, nonGeneratedPart);
	}
	
	@Override
	public void accept(final de.fhdw.wtf.generator.java.visitor.GenClassVisitor visitor) {
		visitor.handle(this);
		
	}
	
	@Override
	public <X> X accept(final GenClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenClassVisitorException<X> visitor) throws X {
		visitor.handle(this);
		
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(GenInterfaceClassVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenInterfaceClassVisitorReturn<X> visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <Y>
	 *            The exception that can be thrown by the handle method.
	 * @throws Y
	 *             Throws an exception of type <X> when the handle method throws it.
	 */
	public abstract <Y extends java.lang.Exception> void accept(GenInterfaceClassVisitorException<Y> visitor) throws Y;
	
}
