/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.generatorModel;

public final class GenComment {
    private final String text;
    private static final String COMMENT_START = "/**";
    private static final String COMMENT_STAR = " * ";
    private static final String COMMENT_END = " */";
    private static final String TAB = "\t";
    private static final String NEXTLINE = "\n";
    private static final String NEXTLINE_REGEX = "\\n";

    private GenComment(String text) {
        this.text = text;
    }

    public static GenComment create(String text) {
        return new GenComment(text);
    }

    public static GenComment createFromPlainText(String text, boolean operationComment) {
        String[] commentLines;
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        for (String commentLine : commentLines = text.split(NEXTLINE_REGEX)) {
            if (operationComment) {
                result.append(TAB);
            }
            result.append(COMMENT_STAR + commentLine + NEXTLINE);
        }
        if (operationComment) {
            result.append(TAB);
        }
        result.append(COMMENT_END);
        return new GenComment(result.toString());
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GenComment) {
            GenComment others = (GenComment)obj;
            return others.getText().equals(this.text);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return this.text;
    }
}

