package de.fhdw.wtf.generator.java.generatorModel;

/**
 * A class that represents the "Int"-class from wtf-sources.
 */
public final class GenIntegerClass extends GenPrimitiveClass {
	
	/**
	 * The one instance of this class.
	 */
	private static GenIntegerClass instance = null;
	
	/**
	 * Instantiates a new GenIntegerClass.
	 */
	private GenIntegerClass() {
		super(GenIntegerType.getInstance());
	}
	
	/**
	 * Returns the one existing instance of this class.
	 * 
	 * @return GenIntegerClass
	 */
	public static synchronized GenIntegerClass getInstance() {
		if (instance == null) {
			instance = new GenIntegerClass();
		}
		return instance;
	}
	
}
