package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Iterator;
import java.util.List;

import de.fhdw.wtf.generator.transformer.clipper.ClipToFileTask;

/**
 * Represents the signature of a GenJavaOperation to make operations comparable.
 */
public final class GenOperationSignature {
	
	/**
	 * Name of the Operation.
	 */
	private final String name;
	
	/**
	 * Parameters of the operation.
	 */
	private final List<GenParameter> parameters;
	
	/**
	 * Private Constructor.
	 * 
	 * @param name
	 *            - name of the operation
	 * @param parameters
	 *            - parameters of the operation
	 */
	private GenOperationSignature(final String name, final List<GenParameter> parameters) {
		this.name = name;
		this.parameters = parameters;
	}
	
	/**
	 * Factory Method for {@link GenOperationSignature}.
	 * 
	 * @param name
	 *            - name of the operation.
	 * @param parameters
	 *            - parameters of the operation.
	 * @return - new Signature-Object.
	 */
	public static GenOperationSignature create(final String name, final List<GenParameter> parameters) {
		return new GenOperationSignature(name, parameters);
	}
	
	/**
	 * Returns the parameters of the operation.
	 * 
	 * @return - parameters
	 */
	public List<GenParameter> getParameters() {
		return this.parameters;
	}
	
	/**
	 * Returns the name of the operation.
	 * 
	 * @return - name
	 */
	public String getName() {
		return this.name;
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (obj instanceof GenOperationSignature) {
			final GenOperationSignature other = (GenOperationSignature) obj;
			if (this.getName().equals(other.getName())) {
				return GenOperationSignature.equalsParamTypes(this.getParameters(), other.getParameters());
			}
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return this.getName().hashCode() ^ this.getParameters().hashCode();
	}
	
	@Override
	public String toString() {
		final StringBuffer result = new StringBuffer(this.name);
		result.append('(');
		if (!this.parameters.isEmpty()) {
			for (final GenParameter param : this.parameters) {
				result.append(param);
				result.append(',');
			}
			result.deleteCharAt(result.length() - 1);
		}
		result.append(')');
		return result.toString();
	}
	
	/**
	 * Returns true, if and only if the param types equal in name.
	 * 
	 * @param a
	 *            first operation
	 * @param b
	 *            second operation
	 * @return see above
	 */
	public static boolean equalsParamTypes(final List<GenParameter> a, final List<GenParameter> b) {
		if (a.size() == b.size()) {
			final Iterator<GenParameter> i = a.iterator();
			final Iterator<GenParameter> j = b.iterator();
			while (i.hasNext()) {
				final GenParameter currentI = i.next();
				if (j.hasNext()) {
					final GenParameter currentJ = j.next();
					if (!ClipToFileTask.replaceIllegalChars(
							currentI.getTyp().getFullyQualifiedNameWithGenericArguments()).equals(
							ClipToFileTask.replaceIllegalChars(currentJ.getTyp()
									.getFullyQualifiedNameWithGenericArguments()))) {
						return false;
					}
				}
			}
		}
		return true;
	}
	
}
