package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenerationModelItemVisitor;

/**
 * A class for every item that can be generated.
 */
public abstract class GenerationModelItem {
	
	/**
	 * The name of the item that can be generated.
	 */
	private String name;
	
	/**
	 * Instantiates a new GenerationModelItem.
	 * 
	 * @param name
	 *            The name of the item that can be generated.
	 */
	protected GenerationModelItem(final String name) {
		this.name = name;
	}
	
	/**
	 * Calls the handle method for this type in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor that handles this type.
	 */
	public abstract void accept(GenerationModelItemVisitor visitor);
	
	/**
	 * Returns the name of this item.
	 * 
	 * @return String
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * Sets the name of this item.
	 * 
	 * @param name
	 *            String The name to set.
	 */
	public void setName(final String name) {
		this.name = name;
	}
	
}
