package de.fhdw.wtf.generator.transformer.clipper;

/**
 * Contains the configuration for the {@link ClipToFileTask}.
 */
public class ClipperConfiguration {
	
	/**
	 * The root directory where the clipped files should be written and where the clipper can read the files for
	 * generation.
	 */
	private final String repoDirectoryRoot;
	
	/**
	 * The root directory of the java files.
	 */
	private final String javaDirectoryRoot;
	
	/**
	 * Constructor.
	 * 
	 * @param repoDirectoryRoot
	 *            - the root directory of the clipper repository.
	 * @param javaDirectoryRoot
	 *            - the directory for the input java files.
	 */
	public ClipperConfiguration(final String repoDirectoryRoot, final String javaDirectoryRoot) {
		this.repoDirectoryRoot = repoDirectoryRoot;
		this.javaDirectoryRoot = javaDirectoryRoot;
	}
	
	/**
	 * Returns the root directory of the clipper repository.
	 * 
	 * @return - root directory of the clipper repository
	 */
	public String getRepoDirectoryRoot() {
		return this.repoDirectoryRoot;
	}
	
	/**
	 * Returns the directory for the input java files.
	 * 
	 * @return - directory for the input java files
	 */
	public String getJavaDirectoryRoot() {
		return this.javaDirectoryRoot;
	}
	
}
