package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;

/**
 * This visitor handles all GenClass-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenClassVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenClassClass-type.
	 * 
	 * @param classClass
	 *            GenClassClass to handle.
	 * @return Value of type X
	 */
	X handle(GenClassClass classClass);
	
	/**
	 * Handle method for objects of GenInterfaceClass-type.
	 * 
	 * @param interfaceClass
	 *            GenInterfaceClass to handle.
	 * @return Value of type X
	 */
	X handle(GenInterfaceClass interfaceClass);
	
	/**
	 * Handle method for objects of GenPrimitiveClass-type.
	 * 
	 * @param primitiveClass
	 *            GenPrimitiveClass to handle.
	 * @return Value of type X
	 */
	X handle(GenPrimitiveClass primitiveClass);
}
