/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.tasks;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitor;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import de.fhdw.wtf.generator.writer.writer.ExceptionFileWriter;
import de.fhdw.wtf.generator.writer.writer.FileHeaderWriter;
import de.fhdw.wtf.generator.writer.writer.JavaAspectClassFileWriter;
import de.fhdw.wtf.generator.writer.writer.JavaClassFileWriter;
import de.fhdw.wtf.generator.writer.writer.JavaInterfaceClassFileWriter;
import java.io.File;

public class FileWriterTask
extends SimpleGeneratorModelWalkerTask {
    private final JavaInterfaceClassFileWriter interfaceWriter = new JavaInterfaceClassFileWriter(true);
    private final JavaClassFileWriter classWriter = new JavaClassFileWriter(true);
    private final JavaAspectClassFileWriter aspectWriter = new JavaAspectClassFileWriter(true);
    private final ExceptionFileWriter exceptionWriter = new ExceptionFileWriter(true);
    private final File rootDir;

    public FileWriterTask(TaskExecutor taskmanager, GeneratorModel model, String rootDir, DependencyTask clipper) {
        super(taskmanager, model);
        this.rootDir = new File(rootDir);
        try {
            this.addDependency(clipper);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in FileWriterTask.");
        }
    }

    @Override
    public void handleClassClass(GenClassClass cc) throws TaskException {
        cc.accept(new GenClassClassVisitor(){

            @Override
            public void handle(GenAspect aspect) {
                FileHeaderWriter writer = new FileHeaderWriter(FileWriterTask.this.aspectWriter);
                writer.writeGenClass(aspect, FileWriterTask.this.rootDir);
            }

            @Override
            public void handle(GenUserClass userclass) {
                FileHeaderWriter writer = new FileHeaderWriter(FileWriterTask.this.classWriter);
                writer.writeGenClass(userclass, FileWriterTask.this.rootDir);
            }

            @Override
            public void handle(GenJavaException javaE) {
            }

            @Override
            public void handle(GenAnyType anyType) {
            }

            @Override
            public void handle(GenException exceptionClass) {
                FileHeaderWriter headerWriter = new FileHeaderWriter(FileWriterTask.this.exceptionWriter);
                headerWriter.writeGenClass(exceptionClass, FileWriterTask.this.rootDir);
            }

            @Override
            public void handle(GenExternalClassClass externalClass) {
            }
        });
    }

    @Override
    public void handleInterfaceClass(GenInterfaceClass ic) throws TaskException {
        ic.accept(new GenInterfaceClassVisitor(){

            @Override
            public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                FileHeaderWriter writer = new FileHeaderWriter(FileWriterTask.this.interfaceWriter);
                writer.writeGenClass(interfaceWithImplClass, FileWriterTask.this.rootDir);
                FileHeaderWriter classWriter = new FileHeaderWriter(FileWriterTask.this.classWriter);
                classWriter.writeGenClass(interfaceWithImplClass.getClassRepresentation(), FileWriterTask.this.rootDir);
            }

            @Override
            public void handle(GenSimpleInterfaceClass simpleInterface) {
                FileHeaderWriter writer = new FileHeaderWriter(FileWriterTask.this.interfaceWriter);
                writer.writeGenClass(simpleInterface, FileWriterTask.this.rootDir);
            }

            @Override
            public void handle(GenExternalInterfaceClass iface) {
            }
        });
    }

    @Override
    public void finalizeTask() throws TaskException {
    }

    public String toString() {
        return "Filewriting";
    }

    @Override
    public void handleOperation(GenOperation o) throws TaskException {
    }
}

