package de.fhdw.wtf.generator.java.generatorModel;

public final class GenDeclareInheritance {
	
	private final GenClass subClass;
	private final GenInterfaceClass superClass;
	private static final String INHERITS_FROM = " inherits from ";
	/**
	 * Represents the String "null".
	 */
	private static final String NULL = "null";
	
	private GenDeclareInheritance(final GenInterfaceClass superClass, final GenClass subClass) {
		this.subClass = subClass;
		this.superClass = superClass;
	}
	
	public static GenDeclareInheritance create(final GenInterfaceClass superClass, final GenClass subType) {
		return new GenDeclareInheritance(superClass, subType);
	}
	
	public GenInterfaceClass getSuperClass() {
		return this.superClass;
	}
	
	public GenClass getSubClass() {
		return this.subClass;
	}
	
	@Override
	public String toString() {
		String pre = NULL;
		if (this.subClass != null) {
			pre = this.subClass.toString();
		}
		
		String post = NULL;
		if (this.superClass != null) {
			post = this.superClass.toString();
		}
		
		return pre + INHERITS_FROM + post;
	}
}
