/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.mojo;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.exception.editor.CheckException;
import de.fhdw.wtf.common.exception.editor.MultipleCheckExceptions;
import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.CyclicPartDefinitionException;
import de.fhdw.wtf.facade.ModelManager;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class FullGenerate
extends AbstractMojo {
    private File root;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting generation");
        try {
            if (this.root == null) {
                this.getLog().error((CharSequence)"Root Path is null");
                this.root = new File(".");
            }
            this.getLog().info((CharSequence)("Execution Path is " + this.root.getPath()));
            URI modelUri = new URI("file://" + this.root.getPath().replace('\\', '/') + "/src/main/resources/models/model.wtf");
            String outputDir = this.root.getPath() + "/src/main/java";
            String dbProprties = this.root.getPath() + "/src/main/resources/config/oracledb.properties";
            this.getLog().debug((CharSequence)("Model File URI: " + modelUri.toString()));
            this.getLog().debug((CharSequence)("Output Director: " + outputDir));
            this.getLog().debug((CharSequence)("Database Properties in: " + dbProprties));
            ModelManager modelManager = ModelManager.getInstance();
            this.getLog().info((CharSequence)"Parsing Model");
            try {
                Model modelFromFile = modelManager.getModelFromFile(modelUri);
                GeneratorModel genModel = modelManager.generateJava(modelFromFile, outputDir);
                modelManager.generatePersistence(modelFromFile, genModel, dbProprties);
            }
            catch (MultipleCheckExceptions e) {
                Iterator i = e.iterator();
                while (i.hasNext()) {
                    CheckException current = (CheckException)i.next();
                    this.getLog().error((Throwable)current);
                }
            }
            catch (CyclicDependencyException | CyclicPartDefinitionException | InterruptedException | ExecutionException e1) {
                this.getLog().error(e1);
            }
        }
        catch (URISyntaxException e) {
            this.getLog().error((Throwable)e);
        }
    }
}

