package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;
import java.util.Vector;

import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;

public final class GenAspect extends GenClassClass {
	
	private final Collection<GenJoinpoint> joinpoints;
	private final Collection<GenAdvice> advices;
	private final Collection<GenDeclareInheritance> declareParents;
	private final Collection<GenAspectOperation> aspectOperations;
	private final Collection<GenAspectAttribute> aspectAttributes;
	
	private GenAspect(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenAspectOperation> aspectOperations,
			final Collection<GenInterfaceClass> impl,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenAspectAttribute> aspectAttributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenClassClass ext,
			final GenPackage packag,
			final GenComment comment,
			final String nonGenPart) {
		super(name, operations, impl, attributes, modifiers, constructors, ext, packag, comment, nonGenPart);
		this.aspectAttributes = aspectAttributes;
		this.aspectOperations = aspectOperations;
		this.joinpoints = new Vector<>();
		this.advices = new Vector<>();
		this.declareParents = new Vector<>();
	}
	
	public static GenAspect create(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenAspectOperation> aspectOperations,
			final Collection<GenInterfaceClass> impl,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenAspectAttribute> aspectAttributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenClassClass ext,
			final GenPackage packag,
			final GenComment comment,
			final String nonGenPart) {
		return new GenAspect(name, operations, aspectOperations, impl, attributes, aspectAttributes, modifiers,
				constructors, ext, packag, comment, nonGenPart);
	}
	
	@Override
	public void accept(final GenClassClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenClassClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	public Collection<GenAdvice> getAdvices() {
		return this.advices;
	}
	
	public Collection<GenJoinpoint> getJoinpoints() {
		return this.joinpoints;
	}
	
	public Collection<GenDeclareInheritance> getDeclareParents() {
		return this.declareParents;
	}
	
	public void addDeclareParents(final GenDeclareInheritance declareInheritance) {
		this.declareParents.add(declareInheritance);
	}
	
	public Collection<GenAttribute> getAllAttributes() {
		final Collection<GenAttribute> result = new Vector<>();
		result.addAll(super.getAttributes());
		result.addAll(this.aspectAttributes);
		return result;
	}
	
	public Collection<GenOperation> getAllOperations() {
		final Collection<GenOperation> result = new Vector<>();
		result.addAll(super.getOperationsInner());
		result.addAll(this.aspectOperations);
		return result;
	}
	
	public void addAspectAtt(final GenAspectAttribute attr) {
		this.aspectAttributes.add(attr);
	}
	
	public Collection<GenAspectOperation> getAspectOperations() {
		return this.aspectOperations;
	}
	
	public void addAspectOperation(final GenAspectOperation newOperation) {
		this.aspectOperations.add(newOperation);
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
	@Override
	public String toString() {
		return this.getName();
	}
	
	@Override
	public String getFileEnding() {
		return ".aj";
	}
	
	@Override
	public <Y extends Exception> void accept(final GenClassClassVisitorException<Y> visitor) throws Y {
		visitor.handle(this);
	}
}
