package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenCollectionTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;

/**
 * Represents a collection type in the generator model.
 */
public abstract class GenCollectionType extends GenType {
	
	/**
	 * The collection's value type.
	 */
	private GenType type;
	
	/**
	 * Returns the collection's value type.
	 *
	 * @return The collection's value type.
	 */
	public GenType getType() {
		return this.type;
	}
	
	/**
	 * Sets the collection's value type.
	 *
	 * @param type
	 *            The collection's new value type.
	 */
	public void setType(final GenType type) {
		this.type = type;
	}
	
	/**
	 * Package of the Context classes representing collections.
	 */
	protected static final String PACKAGE = "de.fhdw.wtf.context.model.collections.";
	/**
	 * Starts a list of generic type argument.
	 */
	protected static final String GEN_OPEN = "<";
	/**
	 * Ends a list of generic type argument.
	 */
	protected static final String GEN_CLOSE = ">";
	/**
	 * Separates generic arguments.
	 */
	protected static final String COMMA = ",";
	
	/**
	 * Creates a {@link GenCollectionType} object.
	 *
	 * @param name
	 *            The name of the collection class.
	 * @param type
	 *            The collection's value type.
	 */
	protected GenCollectionType(final String name, final GenType type) {
		super(name);
		this.type = type;
	}
	
	/**
	 * Calls the correct operation in the given visitor.
	 *
	 * @param visitor
	 *            The visitor to handle this collection type.
	 */
	public abstract void accept(GenCollectionTypeVisitor visitor);
	
	@Override
	public void accept(final GenTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return PACKAGE + this.getName();
	}
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenTypeVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
}
