package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;

public abstract class GenClassClass extends GenClass {
	
	private final Collection<GenJavaAttribute> attributes;
	private final Collection<GenClassModifier> modifieres;
	private final Collection<GenJavaOperation> constructors;
	
	/**
	 * The GenClassClass this GenClassClass shall extend.
	 */
	private GenClassClass extend;
	
	/**
	 * Constructor for GenClassClass.
	 * 
	 * @param name
	 *            The name of the class and the java-file to generate.
	 * @param attributes
	 *            The attribute the class has.
	 * @param operations
	 *            The operations the class has.
	 * @param modifiers
	 *            The class-modifiers for this class. For example "public".
	 * @param constructors
	 *            The constructor-operations for this class.
	 * @param implement
	 *            The interfaces the class implements.
	 * @param extend
	 *            The class the class extends.
	 * @param comment
	 *            The comment that describes this class.
	 * @param packag
	 *            The package the class will be generated in.
	 * @param nonGeneratedPart
	 *            Additional lines of code.
	 */
	protected GenClassClass(final String name,
			final Collection<GenJavaOperation> operations,
			final Collection<GenInterfaceClass> implement,
			final Collection<GenJavaAttribute> attributes,
			final Collection<GenClassModifier> modifiers,
			final Collection<GenJavaOperation> constructors,
			final GenClassClass extend,
			final GenPackage packag,
			final GenComment comment,
			final String nonGeneratedPart) {
		super(name, operations, implement, packag, comment, nonGeneratedPart);
		this.attributes = attributes;
		this.modifieres = modifiers;
		this.constructors = constructors;
		this.extend = extend;
	}
	
	@Override
	public void accept(final de.fhdw.wtf.generator.java.visitor.GenClassVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenClassVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(GenClassClassVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returnType of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenClassClassVisitorReturn<X> visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <Y>
	 *            The exception that could be thrown by calling this method.
	 * @throws Y
	 *             The given exception
	 */
	public abstract <Y extends java.lang.Exception> void accept(GenClassClassVisitorException<Y> visitor) throws Y;
	
	@Override
	public <X extends java.lang.Exception> void accept(final GenClassVisitorException<X> visitor) throws X {
		visitor.handle(this);
	}
	
	/**
	 * Returns the attributes of this GenClassClass.
	 * 
	 * @return Collection<GenJavaAttribute>
	 */
	public Collection<GenJavaAttribute> getAttributes() {
		return this.attributes;
	}
	
	/**
	 * Returns the GenClassModifiers of this GenClassClass.
	 * 
	 * @return Collection<GenClassModifiers>
	 */
	public Collection<GenClassModifier> getModifieres() {
		return this.modifieres;
	}
	
	/**
	 * Returns all constructor methods of this GenClassClass.
	 * 
	 * @return Collection<GenJavaOperation>
	 */
	public Collection<GenJavaOperation> getConstructors() {
		return this.constructors;
	}
	
	/**
	 * Adds the given GenJavaOperation as constructor to this class.
	 * 
	 * @param constructor
	 *            the constructor.
	 */
	public void addConstructor(final GenJavaOperation constructor) {
		this.constructors.add(constructor);
	}
	
	/**
	 * Returns the GenClassClass this GenClassClass extends.
	 * 
	 * @return GenClassClass
	 */
	public GenClassClass getExtend() {
		return this.extend;
	}
	
	/**
	 * Sets the extends declaration from this GenClassClass to the provided GenClassClass. Beware! It is not possible to
	 * extends more than one GenClassClass.
	 * 
	 * @param extend
	 *            The GenClass to extend.
	 */
	public void setExtend(final GenClassClass extend) {
		this.extend = extend;
	}
	
}
