package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;
import java.util.List;
import java.util.Vector;

import de.fhdw.wtf.generator.java.visitor.GenOperationVisitorReturn;

public final class GenJavaOperation extends GenOperation {
	
	private final GenOperationSignature signature;
	
	private GenJavaOperation(final String name, final List<GenParameter> parameters, final GenOperationState state) {
		super(name, parameters, state);
		this.signature = GenOperationSignature.create(this.getName(), this.getParameters());
	}
	
	public static GenJavaOperation create(final String name,
			final List<GenParameter> parameters,
			final GenOperationState state) {
		return new GenJavaOperation(name, parameters, state);
	}
	
	public static GenJavaOperation create(final String name,
			final GenVisibility visibility,
			final List<GenParameter> params,
			final Collection<GenException> exceptions,
			final String method,
			final GenType typ,
			final Collection<GenOperationModifier> operationModifier,
			final GenComment comment) {
		return new GenJavaOperation(name, params, GenFullParsedOperationState.create(
				comment,
				exceptions,
				GenTypeReferenceByReference.create(typ),
				operationModifier,
				visibility,
				method));
	}
	
	public static GenJavaOperation createConstructor(final GenType container,
			final GenVisibility visibility,
			final List<GenParameter> params,
			final Collection<GenException> exceptions,
			final String method,
			final GenComment comment) {
		return new GenJavaOperation(container.getFullyQualifiedTypeName(), params, GenFullParsedOperationState.create(
				comment,
				exceptions,
				GenTypeReferenceByName.create(container.getFullyQualifiedTypeName()),
				new Vector<GenOperationModifier>(),
				visibility,
				method));
	}
	
	@Override
	public <T> T accept(final GenOperationVisitorReturn<T> visitor) {
		return visitor.handleJavaOperation(this);
	}
	
	@Override
	public String toString() {
		final StringBuffer result = new StringBuffer();
		if (!this.getGenerics().isEmpty()) {
			result.append('<');
			for (final GenType type : this.getGenerics()) {
				result.append(type.getName());
				result.append(',');
			}
			result.deleteCharAt(result.length() - 1);
			result.append("> ");
		}
		result.append(this.signature);
		return result.toString();
	}
	
	/**
	 * Returns the signature (name and parameters) of this operation.
	 * 
	 * @return - {@link GenOperationSignature}.
	 */
	public GenOperationSignature getSignature() {
		return this.signature;
		
	}
}
