package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitorReturn;

/**
 * A class that represents the "Integer"-type known from Java in the generation process.
 */
public final class GenIntegerType extends GenPrimitiveType {
	
	/**
	 * The one instance of this type.
	 */
	private static GenIntegerType instance = null;
	/**
	 * The corresponding class in wtf-sources for this type.
	 */
	private static GenIntegerClass correspondingClass = null;
	
	/**
	 * Instantiates a new GenIntegerType.
	 */
	private GenIntegerType() {
		super(INTERGER_TYPE_NAME);
	}
	
	/**
	 * The name of this type.
	 */
	private static final java.lang.String INTERGER_TYPE_NAME = "Int";
	
	/**
	 * Returns the one existing instance of this type.
	 * 
	 * @return GenIntegerType
	 */
	public static synchronized GenIntegerType getInstance() {
		if (instance == null) {
			instance = new GenIntegerType();
		}
		return instance;
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return BASE_PACKAGE + this.getName();
	}
	
	/**
	 * Returns the one instance of the corresponding class in wtf-sources for this type.
	 * 
	 * @return GenIntegerClass
	 */
	public static synchronized GenIntegerClass getCorrespondingClass() {
		if (correspondingClass == null) {
			correspondingClass = GenIntegerClass.getInstance();
		}
		return GenIntegerType.correspondingClass;
	}
	
	@Override
	public void accept(final GenPrimitiveTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenPrimitiveTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
