package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitorReturn;

/**
 * The pointing operation or attribute knows the name of this type only. It has not been referenced against the Java
 * model (e.g. after operation import).
 * 
 */
public final class GenTypeReferenceByName implements GenTypeReference {
	
	/**
	 * The name of the type that shall be referenced.
	 */
	private final String name;
	
	@Override
	public String getName() {
		return this.name;
	}
	
	@Override
	public String getFullyQualifiedName() {
		return this.getName();
	}
	
	@Override
	public String getFullyQualifiedNameWithGenericArguments() {
		return this.getFullyQualifiedName();
	}
	
	/**
	 * Instantietes a new {@link GenTypeReferenceByName} for the given <code>name</code>.
	 * 
	 * @param name
	 *            The name of the type that shall be referenced.
	 */
	private GenTypeReferenceByName(final String name) {
		this.name = name;
	}
	
	/**
	 * Creates a new {@link GenTypeReferenceByName} for the given <code>name</code>.
	 * 
	 * @param name
	 *            The name of the type that shall be referenced.
	 * @return {@link GenTypeReferenceByName}
	 */
	public static GenTypeReferenceByName create(final String name) {
		return new GenTypeReferenceByName(name);
	}
	
	@Override
	public void accept(final GenTypeReferenceVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <T> T accept(final GenTypeReferenceVisitorReturn<T> visitor) {
		return visitor.handle(this);
	}
	
}
