/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.file;

import de.fhdw.wtf.file.FileIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;

public final class FileUtils {
    private static final String BREAK = "\n";
    private static final String ERROR_MKDIR = "Could not create directory.";
    private static final String ERROR_DELETE = "Could not delete file.";
    private static final String ERROR_CREATE = "Could not create file.";

    private FileUtils() {
    }

    public static void overrideToFile(String content, File path, File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException(ERROR_DELETE);
        }
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException(ERROR_MKDIR);
        }
        if (!file.createNewFile()) {
            throw new IOException(ERROR_CREATE);
        }
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content);
            writer.flush();
        }
    }

    public static String getFileString(String filePath) throws IOException {
        try (FileIterator i = new FileIterator(new File(filePath));){
            StringBuilder b = new StringBuilder();
            while (i.hasNext()) {
                b.append(i.next());
                if (!i.hasNext()) continue;
                b.append(BREAK);
            }
            String string = b.toString();
            return string;
        }
    }

    public static void saveToFile(String content, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content);
            writer.flush();
        }
    }

    public static String printFileList(Collection<File> files) {
        Iterator<File> i = files.iterator();
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            sb.append(i.next().getAbsolutePath());
            sb.append(BREAK);
        }
        return sb.toString();
    }

    public static void deleteDirectory(String dir) throws IOException {
        Path directory = Paths.get(dir, new String[0]);
        if (new File(dir).listFiles() != null) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
                    Files.delete(dir2);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

