/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.exception.walker.CyclicDependencyException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import java.util.Vector;

public class AppStarterTransformer
extends SimpleGeneratorModelWalkerTask {
    private static final String NEW_LINE = "\n";
    private final StringBuilder method = new StringBuilder();

    public AppStarterTransformer(TaskExecutor taskmanager, GeneratorModel javaGeneratorModel, DependencyTask inheritanceTransformer) {
        super(taskmanager, javaGeneratorModel);
        this.method.append("try {");
        this.method.append(NEW_LINE);
        try {
            this.addDependency(inheritanceTransformer);
        }
        catch (CyclicDependencyException e) {
            e.printStackTrace();
            throw new Error("Dependency tasks are cyclic in AppStarterTransformer.");
        }
    }

    @Override
    public void handleClassClass(GenClassClass cc) throws TaskException {
        if (!cc.getModifieres().contains((Object)GenClassModifier.ABSTRACT) && (cc.getFullyQualifiedTypeName().startsWith("generated.model.") || cc.getFullyQualifiedTypeName().startsWith("generated.products."))) {
            this.generateFactoryRegistrationCall(cc, cc);
        }
    }

    @Override
    public void handleInterfaceClass(GenInterfaceClass ic) throws TaskException {
        ic.accept(new GenInterfaceClassVisitorException<TaskException>(){

            @Override
            public void handle(GenSimpleInterfaceClass simpleInterface) throws TaskException {
            }

            @Override
            public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                GenUserClass cc = interfaceWithImplClass.getClassRepresentation();
                if (!cc.getModifieres().contains((Object)GenClassModifier.ABSTRACT)) {
                    AppStarterTransformer.this.generateFactoryRegistrationCall(interfaceWithImplClass, cc);
                }
            }

            @Override
            public void handle(GenExternalInterfaceClass iface) {
            }
        });
    }

    private void generateFactoryRegistrationCall(GenClass iface, GenClass impl) {
        this.method.append("\t\t\tobjectFactoryProvider.registerTypeFactory(typeManager, \"" + impl.getFullyQualifiedTypeName() + "\", new generated.factories." + iface.getName() + "Factory());");
        this.method.append(NEW_LINE);
    }

    @Override
    public void finalizeTask() throws TaskException {
        this.method.append("\t\t}catch (de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException e) {e.printStackTrace();}");
        GenPackage packag = GenUnqualifiedPackage.create("de");
        packag = packag.addName("fhdw");
        packag = packag.addName("wtf");
        packag = packag.addName("context");
        packag = packag.addName("core");
        GenUserClass superC = GenUserClass.create("ApplicationStarter", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), null, packag, GenComment.createFromPlainText("", false), "");
        GenUserClass appStarter = GenUserClass.create("GeneratedApplicationStarter", new Vector<GenJavaOperation>(), new Vector<GenInterfaceClass>(), new Vector<GenJavaAttribute>(), new Vector<GenClassModifier>(), new Vector<GenJavaOperation>(), superC, PackageConstants.APPLICATION_PACKAGE, GenComment.createFromPlainText("Kommi", false), "");
        GenJavaOperation registerTypeFactories = GenJavaOperation.create("registerTypeFactories", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), this.method.toString(), GenVoidType.getInstance(), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        registerTypeFactories.getParameters().add(GenParameter.create("objectFactoryProvider", GenImportType.create("de.fhdw.wtf.context.core.ObjectFactoryProvider")));
        registerTypeFactories.getParameters().add(GenParameter.create("typeManager", GenImportType.create("de.fhdw.wtf.persistence.facade.TypeManager")));
        GenJavaOperation getResourcesPathJava = GenJavaOperation.create("getResourcesPathJava", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "return \"src/main/resources\";", GenImportType.create("String"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        GenJavaOperation getResourcesPathServer = GenJavaOperation.create("getResourcesPathServer", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "return \"WEB-INF\";", GenImportType.create("String"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        GenJavaOperation getApplicationConfigFileName = GenJavaOperation.create("getApplicationConfigFileName", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "return \"config/application.properties\";", GenImportType.create("String"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        GenJavaOperation getDatabaseConfigFileName = GenJavaOperation.create("getDatabaseConfigFileName", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "return \"config/oracledb.properties\";", GenImportType.create("String"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        GenJavaOperation getModelPrefix = GenJavaOperation.create("getModelPrefix", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "return \"generated.model\";", GenImportType.create("String"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        GenJavaOperation registerActivities = GenJavaOperation.create("registerActivities", GenVisibility.PROTECTED, new Vector<GenParameter>(), new Vector<GenException>(), "", GenImportType.create("void"), new Vector<GenOperationModifier>(), GenComment.create("@Override"));
        appStarter.addOperation(getModelPrefix);
        appStarter.addOperation(getApplicationConfigFileName);
        appStarter.addOperation(getDatabaseConfigFileName);
        appStarter.addOperation(getResourcesPathJava);
        appStarter.addOperation(registerTypeFactories);
        appStarter.addOperation(getResourcesPathServer);
        appStarter.addOperation(registerActivities);
        this.getGeneratorModel().addNonAstClass(appStarter);
    }

    public String toString() {
        return "ApplicationStarter generation";
    }

    @Override
    public void handleOperation(GenOperation o) throws TaskException {
    }
}

