package de.fhdw.wtf.generator.java.generatorModel;

import java.util.Collection;

import de.fhdw.wtf.generator.java.visitor.GenAttributeVisitorReturn;

public final class GenAspectAttribute extends GenAttribute {
	
	private final GenClass owner;
	
	private GenAspectAttribute(final String name,
			final GenVisibility visibility,
			final GenTypeReference typ,
			final Collection<GenAttributeModifier> modifiers,
			final GenClass owner) {
		super(name, visibility, typ, modifiers);
		this.owner = owner;
	}
	
	public static GenAspectAttribute create(final String name,
			final GenVisibility visibility,
			final GenType typ,
			final Collection<GenAttributeModifier> modifiers,
			final GenClass owner) {
		return new GenAspectAttribute(name, visibility, GenTypeReferenceByReference.create(typ), modifiers, owner);
	}
	
	/**
	 * Projections.
	 * 
	 * @return owner class
	 */
	public GenClass getOwner() {
		return this.owner;
	}
	
	@Override
	public <T> T accept(final GenAttributeVisitorReturn<T> visitor) {
		return visitor.handleAspectAttribute(this);
	}
	
}
