package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenPrimitiveTypeVisitorReturn;

/**
 * A class that represents the "void"-type known from Java in the generation process.
 */
public class GenVoidType extends GenPrimitiveType {
	
	/**
	 * The one instance of this type.
	 */
	private static GenVoidType instance = null;
	
	/**
	 * Instantiates a new GenVoidType.
	 */
	protected GenVoidType() {
		super(VOID_TYPENAME);
	}
	
	/**
	 * The name of this type.
	 */
	private static final String VOID_TYPENAME = "void";
	
	/**
	 * Returns the one existing instance of this type.
	 * 
	 * @return GenVoidType
	 */
	public static synchronized GenVoidType getInstance() {
		if (instance == null) {
			instance = new GenVoidType();
		}
		return instance;
	}
	
	@Override
	public String getFullyQualifiedTypeName() {
		return VOID_TYPENAME;
	}
	
	@Override
	public void accept(final GenPrimitiveTypeVisitor visitor) {
		visitor.handle(this);
	}
	
	@Override
	public <X> X accept(final GenPrimitiveTypeVisitorReturn<X> visitor) {
		return visitor.handle(this);
	}
}
