package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;

/**
 * This visitor handles all GenInterfaceClass-types.
 */
public interface GenInterfaceClassVisitor {
	
	/**
	 * Handle method for objects of GenSimpleInterfaceClass-type.
	 * 
	 * @param simpleInterface
	 *            GenSimpleInterfaceClass to handle.
	 */
	void handle(GenSimpleInterfaceClass simpleInterface);
	
	/**
	 * Handle method for objects of GenInterfaceWithClassImplClass-type.
	 * 
	 * @param interfaceWithImplClass
	 *            GenInterfaceWithClassImplClass to handle.
	 */
	void handle(GenInterfaceWithClassImplClass interfaceWithImplClass);
	
	/**
	 * Handle method for objects of GenExternalInterfaceClass-type.
	 * 
	 * @param iface
	 *            GenExternalInterfaceClass to handle.
	 */
	void handle(GenExternalInterfaceClass iface);
}
