package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;

/**
 * This visitor handles all GenOperation-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenOperationVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenJavaOperation-type.
	 * 
	 * @param operation
	 *            GenJavaOperation to handle.
	 * @return Value of type X
	 */
	X handleJavaOperation(GenJavaOperation operation);
	
	/**
	 * Handle method for objects of GenAspectOperation-type.
	 * 
	 * @param operation
	 *            GenAspectOperation to handle.
	 * @return Value of type X
	 */
	X handleAspectOperation(GenAspectOperation operation);
	
}
