package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenIntegerType;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;

/**
 * This visitor handles all GenPrimitiveType and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenPrimitiveTypeVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenIntegerType.
	 * 
	 * @param integerType
	 *            GenIntegerType to handle.
	 * @return Value of type X
	 */
	X handle(GenIntegerType integerType);
	
	/**
	 * Handle method for objects of GenStringType.
	 * 
	 * @param stringType
	 *            GenStringType to handle.
	 * @return Value of type X
	 */
	X handle(GenStringType stringType);
	
	/**
	 * Handle method for objects of GenVoidType.
	 * 
	 * @param voidType
	 *            GenVoidType to handle.
	 * @return Value of type X
	 */
	X handle(GenVoidType voidType);
	
}
