package de.fhdw.wtf.generator.java.walker;

import java.util.Iterator;

import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.task.result.ExceptionalTaskResult;
import de.fhdw.wtf.common.task.result.OKTaskResult;
import de.fhdw.wtf.common.task.result.TaskResult;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;

public abstract class SimpleGeneratorModelWalkerTask extends GeneratorModelWalkerTask {
	
	private final GeneratorModel model;
	
	public SimpleGeneratorModelWalkerTask(final TaskExecutor taskmanager, final GeneratorModel javaGeneratorModel) {
		super(taskmanager);
		this.model = javaGeneratorModel;
	}
	
	protected GeneratorModel getGeneratorModel() {
		return this.model;
	}
	
	@Override
	public boolean containsTransitive(final DependencyTask a) {
		return false;
	}
	
	@Override
	public final TaskResult doWork() {
		try {
			final Iterator<GenClass> i = this.model.getClasses().iterator();
			while (i.hasNext()) {
				final GenClass current = i.next();
				current.accept(new GenClassVisitorException<TaskException>() {
					
					@Override
					public void handle(final GenClassClass classClass) throws TaskException {
						SimpleGeneratorModelWalkerTask.this.handleClassClass(classClass);
					}
					
					@Override
					public void handle(final GenInterfaceClass interfaceClass) throws TaskException {
						SimpleGeneratorModelWalkerTask.this.handleInterfaceClass(interfaceClass);
						// nothing to do
					}
					
					@Override
					public void handle(final GenPrimitiveClass primitiveClass) throws TaskException {
						// nothing to do
					}
				});
				final Iterator<GenJavaOperation> j = current.getOperations().iterator();
				while (j.hasNext()) {
					final GenJavaOperation o = j.next();
					this.handleOperation(o);
				}
			}
			this.finalizeTask();
		} catch (final TaskException e) {
			return new ExceptionalTaskResult(e);
		}
		return new OKTaskResult();
	}
	
	/**
	 * This operation will be called ONCE at the end of the task!
	 * 
	 * @throws TaskException
	 *             may be thrown by the implementing task
	 */
	public abstract void finalizeTask() throws TaskException;
}
