package de.fhdw.wtf.generator.writer.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

import org.apache.velocity.context.Context;

import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenDeclareInheritance;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;

public class JavaAspectClassFileWriter extends ClassClassFileWriter {
	
	private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/aspectclass.vm";
	private static final String DECLARE_PARENTS_IMPL_KEY = "declareParentsImpl";
	private static final String SUBTYPE_KEY = "subType";
	private static final String SUPERTYPE_KEY = "superType";
	
	public JavaAspectClassFileWriter(final boolean fullyQualified) {
		super(TEMPLATE_FILE_NAME, fullyQualified);
	}
	
	public void writeAspectClass(final GenAspect c, final File rootdir) {
		this.writeClassClass(c);
		this.setUpContext(c, this.getCurrentContext());
		this.writeToFile(c, rootdir);
	}
	
	private void setUpContext(final GenAspect c, final Context currentContext) {
		this.setAttributes(c, currentContext);
		this.setOperations(c, currentContext);
		this.setdeclareParents(c, currentContext);
	}
	
	private void setdeclareParents(final GenAspect c, final Context currentContext) {
		final Vector<HashMap<String, String>> declares = new Vector<>();
		for (final GenDeclareInheritance declare : c.getDeclareParents()) {
			final HashMap<String, String> currentDeclare = new HashMap<>();
			currentDeclare.put(SUBTYPE_KEY, this.typeToString(declare.getSubClass()));
			currentDeclare.put(SUPERTYPE_KEY, this.typeToString(declare.getSuperClass()));
			declares.add(currentDeclare);
		}
		currentContext.put(DECLARE_PARENTS_IMPL_KEY, declares);
	}
	
	private void setOperations(final GenAspect c, final Context currentContext) {
		currentContext.put(PARSED_OPERATIONS_KEY, this.getParsedOperations(c.getAllOperations()));
		final Collection<GenJavaOperation> operationsWithSimple = new ArrayList<>();
		operationsWithSimple.addAll(c.getOperations());
		operationsWithSimple.addAll(c.getConstructors());
		currentContext.put(SIMPLE_OPERATIONS_KEY, this.getSimpleOperations(operationsWithSimple));
	}
	
	private void setAttributes(final GenAspect c, final Context currentContext) {
		currentContext.put(ATTRIBUTES_KEY, this.getAttributes(c.getAllAttributes()));
	}
	
	@Override
	public String getStringContent(final GenClass c) {
		final GenAspect cAsGenUserClass = (GenAspect) c;
		this.writeClassClass(cAsGenUserClass);
		this.setUpContext(cAsGenUserClass, this.getCurrentContext());
		return this.writeToString();
	}
}
