/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.java.walker;

import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.DependencyTask;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.common.task.result.ExceptionalTaskResult;
import de.fhdw.wtf.common.task.result.OKTaskResult;
import de.fhdw.wtf.common.task.result.TaskResult;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.walker.GeneratorModelWalkerTask;

public abstract class SimpleGeneratorModelWalkerTask
extends GeneratorModelWalkerTask {
    private final GeneratorModel model;

    public SimpleGeneratorModelWalkerTask(TaskExecutor taskmanager, GeneratorModel javaGeneratorModel) {
        super(taskmanager);
        this.model = javaGeneratorModel;
    }

    protected GeneratorModel getGeneratorModel() {
        return this.model;
    }

    public boolean containsTransitive(DependencyTask a) {
        return false;
    }

    public final TaskResult doWork() {
        try {
            for (GenClass current : this.model.getClasses()) {
                current.accept(new GenClassVisitorException<TaskException>(){

                    @Override
                    public void handle(GenClassClass classClass) throws TaskException {
                        SimpleGeneratorModelWalkerTask.this.handleClassClass(classClass);
                    }

                    @Override
                    public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                        SimpleGeneratorModelWalkerTask.this.handleInterfaceClass(interfaceClass);
                    }

                    @Override
                    public void handle(GenPrimitiveClass primitiveClass) throws TaskException {
                    }
                });
                for (GenJavaOperation o : current.getOperations()) {
                    this.handleOperation(o);
                }
            }
            this.finalizeTask();
        }
        catch (TaskException e) {
            return new ExceptionalTaskResult((Exception)((Object)e));
        }
        return new OKTaskResult();
    }

    public abstract void finalizeTask() throws TaskException;
}

