/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.clipper;

import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.transformer.clipper.ClipToFileTask;
import de.fhdw.wtf.generator.transformer.exception.ClipperImportFormatException;
import de.fhdw.wtf.generator.transformer.exception.NoMatchingMethodException;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ClipperUtils {
    private static final String JAVA_STRING_LITERAL_SINGLE_SIGN = "'";
    private static final String JAVA_STRING_LITERAL_DOUBLE_SIGN = "\"";
    public static final String IDENTIFIER_REGEX = "[A-Za-z_$\u20ac][\\.A-Za-z_$\u20ac0-9]*";
    public static final String CONSTRUCTOR_FILENAME = "#constructor";
    public static final String PROTECTED_AREA_FILENAME = "#protectedArea";
    public static final String CLASSCOMMENT_FILENAME = "#classcomment";
    public static final String IMPORTS_FILENAME = "#imports";
    public static final String ERRORFILE_FILENAME = "#errorFile";
    public static final String SEPERATOR = "#";
    public static final String ATTRIBUTE_START = "#attr#";
    public static final String PARAMETER_SEPARATOR = ",";
    public static final String GENERIC_OPEN = "<";
    public static final String GENERIC_OPEN_REPLACEMENT = "%{";
    public static final String GENERIC_CLOSE = ">";
    public static final String GENERIC_CLOSE_REPLACEMENT = "%}";
    public static final String REPLACEMENT_FOR_ILLEGAL_CHAR = "_";
    public static final String FILE_ENDING = ".java";
    public static final String NON_GEN_PART_MATCH = ".*// --> NON-GENERATION-PART <--(.*)}\\s*";
    public static final String COMMENT_OPEN = "/*";
    public static final String COMMENT_CLOSE = "*/";
    public static final String CLIPPER_ERROR_NO_METHOD = "Clipper Error: No method";

    private ClipperUtils() {
    }

    public static String deleteBlockComments(String file) throws ClipperImportFormatException {
        String result = file;
        String nextStringLiteralDoubleSign = JAVA_STRING_LITERAL_DOUBLE_SIGN;
        String nextStringLiteralSingleSign = JAVA_STRING_LITERAL_SINGLE_SIGN;
        String commentSign = COMMENT_OPEN;
        String commentSignClose = COMMENT_CLOSE;
        int pos = 0;
        int doublePos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_DOUBLE_SIGN, result, pos);
        int singlePos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, result, pos);
        int commentPos = result.indexOf(COMMENT_OPEN);
        while (commentPos >= 0) {
            if (doublePos < commentPos && (doublePos < singlePos || singlePos < 0) && doublePos > 0) {
                pos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_DOUBLE_SIGN, result, doublePos + 1);
            } else if (singlePos < commentPos && (singlePos < doublePos || doublePos < 0) && singlePos > 0) {
                pos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, result, singlePos + 1);
                singlePos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, result, pos + 1);
            } else {
                if (commentPos < pos) break;
                int oldPos = commentPos;
                pos = result.indexOf(COMMENT_CLOSE, commentPos) + 2;
                result = ClipperUtils.replaceFromToWithWhitespace(result, oldPos, pos);
                commentPos = result.indexOf(COMMENT_OPEN, pos);
            }
            if (doublePos < pos && doublePos != -1) {
                doublePos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_DOUBLE_SIGN, result, pos + 1);
            }
            if (singlePos < pos && singlePos != -1) {
                singlePos = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, result, pos + 1);
            }
            if (commentPos < pos && commentPos != -1) {
                commentPos = result.indexOf(COMMENT_OPEN, pos + 1);
            }
            if (pos >= 0) continue;
            throw new ClipperImportFormatException("Error while parsing quotes");
        }
        return result;
    }

    public static String replaceFromToWithWhitespace(String text, int from, int to) {
        String result = text;
        String pre = result.substring(0, from);
        String oldComment = to - from > 0 ? ClipperUtils.generateSpaces(to - from) : "";
        String after = result.substring(to);
        result = pre + oldComment + after;
        return result;
    }

    private static String generateSpaces(int n) {
        return String.format("%1$" + n + "s", "");
    }

    public static int findNextQuotation(String literal, String file, int startPos) {
        int pos = file.indexOf(literal, startPos);
        while (pos > 0) {
            if (ClipperUtils.isNotEscaped(file, pos)) {
                return pos;
            }
            pos = file.indexOf(literal, pos + 1);
        }
        return pos;
    }

    private static boolean isNotEscaped(String file, int pos) {
        int startPos = pos;
        int currentPos = pos;
        while (file.charAt(currentPos - 1) == '\\') {
            --currentPos;
        }
        return (currentPos - startPos) % 2 == 0;
    }

    public static String deleteEndOfLineComments(String file) {
        String pattern = "(?<!\\*)//.*";
        String withoutcomments = file;
        Pattern p = Pattern.compile("(?<!\\*)//.*");
        Matcher m = p.matcher(file);
        while (m.find()) {
            withoutcomments = ClipperUtils.replaceFromToWithWhitespace(withoutcomments, m.start(), m.end());
        }
        return withoutcomments;
    }

    public static Tuple<Integer, Integer> getCommentBefore(int position, String file, String withoutcommentFile) {
        int begin;
        int end = file.lastIndexOf(COMMENT_CLOSE, position);
        if (end > (begin = file.lastIndexOf(COMMENT_OPEN, position)) && end > 0 && begin >= 0 && !withoutcommentFile.substring(end, position).contains(";") && !withoutcommentFile.substring(end, position).contains("{")) {
            return new Tuple<Integer, Integer>(begin, end + 2);
        }
        return new Tuple<Integer, Integer>(position, position);
    }

    public static String deleteStringLiterals(String file) throws ClipperImportFormatException {
        int end1;
        int start1;
        int end2;
        int start2;
        String nextStringLiteralDoubleSign = JAVA_STRING_LITERAL_DOUBLE_SIGN;
        String nextStringLiteralSingleSign = JAVA_STRING_LITERAL_SINGLE_SIGN;
        String withoutComments = file;
        int pos = 0;
        while (true) {
            start2 = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_DOUBLE_SIGN, file, pos);
            end2 = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_DOUBLE_SIGN, file, start2 + 1);
            start1 = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, file, pos);
            end1 = ClipperUtils.findNextQuotation(JAVA_STRING_LITERAL_SINGLE_SIGN, file, start1 + 1);
            if ((end1 < start2 || start2 == -1) && end1 != -1 && start1 != -1) {
                pos = end1 + 1;
                withoutComments = ClipperUtils.replaceFromToWithWhitespace(withoutComments, start1, end1 + 1);
                continue;
            }
            if (end2 >= start1 && start1 != -1 || end2 == -1 || start2 == -1) break;
            pos = end2 + 1;
            withoutComments = ClipperUtils.replaceFromToWithWhitespace(withoutComments, start2, end2 + 1);
        }
        if (start2 != -1 && end2 == -1 || start1 != -1 && end1 == -1) {
            throw new ClipperImportFormatException("Error while parsing quotes");
        }
        return withoutComments;
    }

    public static String simplifyJavaCode(String file) throws ClipperImportFormatException {
        String simpleFile = ClipperUtils.deleteEndOfLineComments(file);
        simpleFile = ClipperUtils.deleteBlockComments(simpleFile);
        simpleFile = ClipperUtils.deleteStringLiterals(simpleFile);
        simpleFile = ClipperUtils.splitInnerClasses(simpleFile);
        simpleFile = ClipperUtils.deleteAttributeImplementations(simpleFile);
        simpleFile = ClipperUtils.deleteAllAnnotations(simpleFile);
        ArrayList<String> modifierList = new ArrayList<String>();
        modifierList.add("private");
        modifierList.add("public");
        modifierList.add("synchronized");
        modifierList.add("protected");
        modifierList.add("transient");
        modifierList.add("static");
        modifierList.add("final");
        modifierList.add("abstract");
        for (String current : modifierList) {
            String regex = "(?<![A-Za-z0-9_])" + current + "(?![A-Za-z0-9_])";
            simpleFile = simpleFile.replaceAll(regex, ClipperUtils.generateSpaces(current.length()));
        }
        return simpleFile;
    }

    private static String deleteAttributeImplementations(String simpleFile) throws ClipperImportFormatException {
        int start;
        String result = simpleFile;
        while ((start = result.indexOf(61)) != -1) {
            int semicolon = result.indexOf(59, start);
            if (semicolon == -1) {
                throw new ClipperImportFormatException("Semicolon missing!");
            }
            result = ClipperUtils.replaceFromToWithWhitespace(result, start, semicolon);
        }
        return result;
    }

    public static String splitInnerClasses(String simpleFile) throws ClipperImportFormatException {
        String result = "";
        String suffix = simpleFile;
        int classIndex = suffix.indexOf(" class ");
        int interfaceIndex = suffix.indexOf(" interface ");
        int start = classIndex > -1 && interfaceIndex > -1 ? Math.min(classIndex, interfaceIndex) : Math.max(classIndex, interfaceIndex);
        int open = suffix.indexOf(123);
        while (open > -1) {
            Integer close = ClipToFileTask.findCorrespondingClosingCurlyBracket(open, suffix);
            if (start == -1 || start > open) {
                String sub = suffix.substring(0, close);
                result = result + ClipperUtils.replaceFromToWithWhitespace(sub, open, close) + ";";
                suffix = suffix.substring(close + 1);
            } else {
                result = result + suffix.substring(0, open + 1);
                String core = suffix.substring(open + 1, close);
                result = result + ClipperUtils.splitInnerClasses(core);
                suffix = suffix.substring(close);
            }
            start = Math.max(suffix.indexOf(" class "), suffix.indexOf(" interface "));
            open = suffix.indexOf(123);
        }
        return result + (suffix.length() > 0 ? suffix : "");
    }

    private static String deleteAllAnnotations(String withoutcommentFile) {
        int indexStart;
        String result = withoutcommentFile;
        while ((indexStart = result.indexOf(64)) != -1) {
            String pattern = "@\\s*[A-Za-z0-9]+.*\\n";
            Pattern p = Pattern.compile("@\\s*[A-Za-z0-9]+.*\\n");
            Matcher m = p.matcher(result);
            if (!m.find(indexStart)) continue;
            int indexEnd = m.end() - 1;
            result = ClipperUtils.replaceFromToWithWhitespace(result, indexStart, indexEnd);
        }
        return result;
    }

    public static Integer findCorrespondingClosingCurlyBracket(int openBracketPos, String file) throws ClipperImportFormatException {
        Integer result = openBracketPos;
        Integer openBracketMinusClosed = 1;
        while (openBracketMinusClosed != 0) {
            Integer n;
            Integer n2;
            int indexOfOpen;
            int indexOfClose = file.indexOf(String.valueOf('}'), result + 1);
            if (indexOfClose < (indexOfOpen = file.indexOf(String.valueOf('{'), result + 1)) || indexOfOpen == -1) {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed - 1);
                result = indexOfClose;
            } else {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed + 1);
                result = indexOfOpen;
            }
            if (indexOfClose != -1) continue;
            throw new ClipperImportFormatException("Unbalanced Brackets!");
        }
        return result;
    }

    public static Integer findCorrespondingClosingRoundBracket(int openBracketPos, String file) throws ClipperImportFormatException {
        Integer result = openBracketPos;
        Integer openBracketMinusClosed = 1;
        while (openBracketMinusClosed != 0) {
            Integer n;
            Integer n2;
            int indexOfOpen;
            int indexOfClose = file.indexOf(String.valueOf(')'), result + 1);
            if (indexOfClose < (indexOfOpen = file.indexOf(String.valueOf('('), result + 1)) || indexOfOpen == -1) {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed - 1);
                result = indexOfClose;
            } else {
                n2 = openBracketMinusClosed;
                n = openBracketMinusClosed = Integer.valueOf(openBracketMinusClosed + 1);
                result = indexOfOpen;
            }
            if (indexOfClose != -1) continue;
            throw new ClipperImportFormatException("Unbalanced Brackets!");
        }
        return result;
    }

    public static String deleteAllGenerics(String file) throws ClipperImportFormatException {
        String withoutComments = file;
        String genericsBeginSign = GENERIC_OPEN;
        String genericsEndSign = GENERIC_CLOSE;
        int bracketCounter = 0;
        int startBracketOpen = 0;
        int pos = 0;
        while (true) {
            int start = ClipperUtils.findNextQuotation(GENERIC_OPEN, file, pos);
            int end = ClipperUtils.findNextQuotation(GENERIC_CLOSE, file, pos);
            if (end == -1) {
                if (bracketCounter == 0) break;
                throw new ClipperImportFormatException("Error while parsing generics");
            }
            if (start < end && start != -1) {
                pos = start + 1;
                if (bracketCounter == 0) {
                    startBracketOpen = start;
                }
                ++bracketCounter;
            } else if (end < start || start == -1) {
                pos = end + 1;
                --bracketCounter;
            }
            if (bracketCounter != 0) continue;
            withoutComments = ClipperUtils.replaceFromToWithWhitespace(withoutComments, startBracketOpen, end + 1);
        }
        return withoutComments;
    }

    public static GenFullParsedOperationState parseOperation(String operation, String opName) throws NoMatchingMethodException {
        String comment;
        ArrayList<GenOperationModifier> modifier;
        String returntype;
        String met;
        ArrayList<GenException> exc;
        GenVisibility vis;
        block6: {
            vis = GenVisibility.DEFAULT;
            exc = new ArrayList<GenException>();
            met = CLIPPER_ERROR_NO_METHOD;
            returntype = null;
            modifier = new ArrayList<GenOperationModifier>();
            try {
                comment = "";
                String withoutCommentsFile = ClipperUtils.deleteEndOfLineComments(operation);
                withoutCommentsFile = ClipperUtils.deleteBlockComments(withoutCommentsFile);
                Matcher m = ClipperUtils.getMatcher(operation, withoutCommentsFile, opName);
                if (m.matches()) {
                    if (ClipperUtils.hasVisi(operation)) {
                        vis = ClipperUtils.parseVisibility(m.group("visi"));
                    }
                    if (m.group("met") != null) {
                        met = m.group("met").trim();
                    }
                    returntype = m.group("ret");
                    if (ClipperUtils.hasComment(operation)) {
                        comment = m.group("comment");
                    }
                    break block6;
                }
                throw new NoMatchingMethodException(operation);
            }
            catch (ClipperImportFormatException e) {
                System.out.println(e.getMessage());
                throw new NoMatchingMethodException(operation);
            }
        }
        return GenFullParsedOperationState.create(GenComment.create(comment), exc, GenTypeReferenceByName.create(returntype), modifier, vis, met);
    }

    private static Matcher getMatcher(String file, String withoutCommentsFile, String opName) {
        String commentReg = "";
        if (ClipperUtils.hasComment(file)) {
            commentReg = "(?<comment>/\\*.*\\*/)";
        }
        String visiReg = "(?<visi>(public|private|protected))";
        if (!ClipperUtils.hasVisi(withoutCommentsFile)) {
            visiReg = visiReg + "?";
        }
        String abstractReg = "(?<abstract>\\sabstract\\s)";
        if (!ClipperUtils.hasAbstract(withoutCommentsFile)) {
            abstractReg = "";
        }
        String returntypeReg = "(?<ret>([a-zA-Z_$\\.<>,]+))";
        String pattern = "\\s*" + commentReg + "\\s*(@[A-Za-z_<>\\(\\))]+)?\\s*" + visiReg + abstractReg + "\\s*" + "(?<ret>([a-zA-Z_$\\.<>,]+))" + "\\s+" + opName + "\\s*\\([^\\)]*\\)\\s*(\\{(?<met>.*)\\}|;)";
        Pattern p = Pattern.compile(pattern, 32);
        Matcher m = p.matcher(file);
        return m;
    }

    private static boolean hasAbstract(String withoutCommentsFile) {
        Pattern patt = Pattern.compile(".*\\sabstract\\s.*", 32);
        Matcher m = patt.matcher(withoutCommentsFile);
        return m.matches();
    }

    private static boolean hasVisi(String file) {
        Pattern patt = Pattern.compile(".*(\\*/)?(\\s*)?(@[A-Za-z_<>\\(\\))]+)?\\s*(public|protected|private).*", 32);
        Matcher m = patt.matcher(file);
        return m.matches();
    }

    private static boolean hasComment(String file) {
        Pattern patt = Pattern.compile("\\s*/\\*.*", 32);
        Matcher m = patt.matcher(file);
        return m.matches();
    }

    private static GenVisibility parseVisibility(String group) {
        switch (group) {
            case "public": {
                return GenVisibility.PUBLIC;
            }
            case "protected": {
                return GenVisibility.PROTECTED;
            }
            case "private": {
                return GenVisibility.PRIVATE;
            }
        }
        return GenVisibility.DEFAULT;
    }
}

