/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.clipper;

import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;
import de.fhdw.wtf.generator.java.walker.SimpleGeneratorModelWalkerTask;
import de.fhdw.wtf.generator.transformer.clipper.ClipperUtils;
import de.fhdw.wtf.generator.transformer.exception.NoMatchingMethodException;

public class ConvertSimpleOperationsToFullParsedTask
extends SimpleGeneratorModelWalkerTask {
    public ConvertSimpleOperationsToFullParsedTask(TaskExecutor taskmanager, GeneratorModel javaGeneratorModel) {
        super(taskmanager, javaGeneratorModel);
    }

    @Override
    public void handleOperation(GenOperation o) throws TaskException {
    }

    @Override
    public void finalizeTask() throws TaskException {
    }

    @Override
    public void handleClassClass(GenClassClass cc) throws TaskException {
        this.convert(cc);
    }

    @Override
    public void handleInterfaceClass(GenInterfaceClass ic) throws TaskException {
        this.convert(ic);
    }

    private void convert(GenClass t) throws TaskException {
        for (GenJavaOperation current : t.getOperations()) {
            try {
                GenFullParsedOperationState newState = this.convertOperation(current);
                current.setState(newState);
            }
            catch (NoMatchingMethodException noMatchingMethodException) {}
        }
    }

    private GenFullParsedOperationState convertOperation(final GenOperation op) throws TaskException {
        return op.getState().accept(new GenOperationStateVisitorReturnException<GenFullParsedOperationState, TaskException>(){

            @Override
            public GenFullParsedOperationState handle(GenFullParsedOperationState s) throws NoMatchingMethodException {
                throw new NoMatchingMethodException(op.getName());
            }

            @Override
            public GenFullParsedOperationState handle(GenSimpleOperationState o) throws TaskException {
                GenJavaOperation modelOperation = o.getOverwrittenOperation();
                GenFullParsedOperationState clippedOperation = ClipperUtils.parseOperation(o.getFullOperationWithPossibleImplementation(), op.getName());
                return this.mergeOp(this.expectFullParsed(modelOperation.getState()), clippedOperation);
            }

            private GenFullParsedOperationState mergeOp(GenFullParsedOperationState modelOperation, GenFullParsedOperationState clippedOperation) {
                modelOperation.setVisibility(modelOperation.getVisibility().min(clippedOperation.getVisibility()));
                modelOperation.setMethodBody(clippedOperation.getMethodBody());
                modelOperation.setComment(clippedOperation.getComment());
                modelOperation.getModifiers().addAll(clippedOperation.getModifiers());
                return clippedOperation;
            }

            private GenFullParsedOperationState expectFullParsed(GenOperationState state) throws TaskException {
                return state.accept(new GenOperationStateVisitorReturnException<GenFullParsedOperationState, TaskException>(){

                    @Override
                    public GenFullParsedOperationState handle(GenSimpleOperationState s) throws TaskException {
                        throw new TaskException("Overridden Model operation must be full parsed.");
                    }

                    @Override
                    public GenFullParsedOperationState handle(GenFullParsedOperationState s) throws TaskException {
                        return s;
                    }
                });
            }
        });
    }
}

