/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.Operation;
import de.fhdw.wtf.common.ast.UnqualifiedName;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassModifier;
import de.fhdw.wtf.common.ast.type.ClassModifierAbstract;
import de.fhdw.wtf.common.ast.type.ClassModifierService;
import de.fhdw.wtf.common.ast.type.ClassModifierTransient;
import de.fhdw.wtf.common.ast.type.ClassModifierVisitable;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ExceptionClassType;
import de.fhdw.wtf.common.ast.type.ListType;
import de.fhdw.wtf.common.ast.type.MapType;
import de.fhdw.wtf.common.ast.type.ProductType;
import de.fhdw.wtf.common.ast.type.RegularClassType;
import de.fhdw.wtf.common.ast.type.SumType;
import de.fhdw.wtf.common.ast.type.ThrownType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.ClassModifierVisitor;
import de.fhdw.wtf.common.ast.visitor.ClassTypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.ClassTypeVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.CompositeTypeVisitorReturnException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorException;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturn;
import de.fhdw.wtf.common.ast.visitor.TypeVisitorReturnException;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.facade.PackageConstants;
import de.fhdw.wtf.facade.TypeNameGenerator;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenIntegerType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenMutableList;
import de.fhdw.wtf.generator.java.generatorModel.GenMutableMap;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenStringType;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVoidType;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.UtilTransformer;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import de.fhdw.wtf.walker.walker.HelperUtils;
import de.fhdw.wtf.walker.walker.SimpleWalkerTaskForTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class TypeTransformer
extends SimpleWalkerTaskForTypes {
    private final GeneratorModel genModel;
    private final UtilTransformer utilTransformer;
    private final Map<Tuple<GenType, Collection<ExceptionClassType>>, Type> typeMapping;
    private final Map<GenMutableMap, MapType> mapTypeMapping;
    private final Map<GenCollectionType, ListType> listTypeMapping;
    private final Map<GenInterfaceClass, Type> interfaceString;
    private final Collection<ClassType> foundClassTypes = new HashSet<ClassType>();
    private static final String DEFAULT_CLASS_COMMENT = "TODO Comment Class.";
    private static final String DEFAULT_EXCEPTION_COMMENT = "TODO Comment Exception.";
    private static final String DEFAULT_PRODUCT_COMMENT = "This class represents an anonym product.";
    private static final String DEFAULT_SUM_COMMENT = "";
    private static final String DEFAULT_NON_GEN_PART = "";
    private static final String ANYTHING_SUM_NAME = "Anything";

    public Collection<ClassType> getFoundClassTypes() {
        return this.foundClassTypes;
    }

    public TypeTransformer(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel) {
        super(m, taskmanager, true);
        this.genModel = generatorModel;
        this.utilTransformer = UtilTransformer.create(this.getGeneratorModel());
        this.typeMapping = new HashMap<Tuple<GenType, Collection<ExceptionClassType>>, Type>();
        this.mapTypeMapping = new HashMap<GenMutableMap, MapType>();
        this.listTypeMapping = new HashMap<GenCollectionType, ListType>();
        this.interfaceString = new HashMap<GenInterfaceClass, Type>();
    }

    public void handleType(Type type) throws TaskException {
        Tuple<GenType, Collection<ExceptionClassType>> genTypes = this.createGenType(type);
        if (genTypes.getA() != null) {
            this.getGeneratorModel().addToMapping(type, genTypes);
        }
    }

    private Tuple<GenType, Collection<ExceptionClassType>> createGenType(Type type) throws TaskException {
        return (Tuple)type.accept((TypeVisitorReturnException)new TypeVisitorReturnException<Tuple<GenType, Collection<ExceptionClassType>>, TaskException>(){

            public Tuple<GenType, Collection<ExceptionClassType>> handle(AtomicType s) throws TaskException {
                return (Tuple)s.accept((AtomicTypeVisitorReturnException)new AtomicTypeVisitorReturnException<Tuple<GenType, Collection<ExceptionClassType>>, TaskException>(){

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(BaseType baseType) throws TaskException {
                        if (baseType.toString().equals("String")) {
                            return new Tuple<GenType, Collection<ExceptionClassType>>(GenStringType.getInstance(), new ArrayList());
                        }
                        if (baseType.toString().equals("Integer")) {
                            return new Tuple<GenType, Collection<ExceptionClassType>>(GenIntegerType.getInstance(), new ArrayList());
                        }
                        return new Tuple(null, new ArrayList());
                    }

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(final ClassType c) throws TaskException {
                        TypeTransformer.this.foundClassTypes.add(c);
                        final String className = c.getName().getLastAddedName().toString();
                        final GenPackage packag = TypeTransformer.this.getUtilTransformer().getPackage(c.getName());
                        final Collection modifiers = TypeTransformer.this.handleClassModifier(c.getModifiers());
                        return (Tuple)c.accept((ClassTypeVisitorReturnException)new ClassTypeVisitorReturnException<Tuple<GenType, Collection<ExceptionClassType>>, TaskException>(){

                            public Tuple<GenType, Collection<ExceptionClassType>> handle(RegularClassType regularClassType) throws TaskException {
                                GenComment comment = GenComment.createFromPlainText(TypeTransformer.DEFAULT_CLASS_COMMENT, false);
                                if (TypeTransformer.this.isInterface((Type)c)) {
                                    GenInterfaceClass result = TypeTransformer.this.getGeneratorModel().createInterface(className, (Type)c, comment, packag, "");
                                    return new Tuple<GenType, Collection<ExceptionClassType>>(result, new ArrayList());
                                }
                                GenInterfaceWithClassImplClass result = TypeTransformer.this.getGeneratorModel().createInterfaceWithImplClass(className, c, modifiers, comment, packag, "");
                                return new Tuple<GenType, Collection<ExceptionClassType>>(result, new ArrayList());
                            }

                            public Tuple<GenType, Collection<ExceptionClassType>> handle(ExceptionClassType exceptionClassType) throws TaskException {
                                GenComment comment = GenComment.createFromPlainText(TypeTransformer.DEFAULT_EXCEPTION_COMMENT, false);
                                GenException result = TypeTransformer.this.getGeneratorModel().createException(className, c, comment, packag, "");
                                return new Tuple<GenType, Collection<ExceptionClassType>>(result, new ArrayList());
                            }
                        });
                    }
                });
            }

            public Tuple<GenType, Collection<ExceptionClassType>> handle(CompositeType c) throws TaskException {
                return (Tuple)c.accept((CompositeTypeVisitorReturnException)new CompositeTypeVisitorReturnException<Tuple<GenType, Collection<ExceptionClassType>>, TaskException>(){

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(MapType map) throws TaskException {
                        GenType key = TypeTransformer.this.tryGetType(map.getKey());
                        GenType value = TypeTransformer.this.tryGetType(map.getOf());
                        GenMutableMap coll = GenMutableMap.create(key, value);
                        TypeTransformer.this.mapTypeMapping.put(coll, map);
                        return new Tuple<GenType, Collection<ExceptionClassType>>(coll, new ArrayList());
                    }

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(ListType list) throws TaskException {
                        GenType valuetype = TypeTransformer.this.tryGetType(list.getOf());
                        GenMutableList coll = GenMutableList.create(valuetype);
                        TypeTransformer.this.listTypeMapping.put(coll, list);
                        return new Tuple<GenType, Collection<ExceptionClassType>>(coll, new ArrayList());
                    }

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(ProductType product) throws TaskException {
                        String pName = TypeNameGenerator.getInstance().getTypeName((Type)product).toString();
                        GenComment comment = GenComment.createFromPlainText(TypeTransformer.DEFAULT_PRODUCT_COMMENT, false);
                        GenUserClass prod = TypeTransformer.this.getGeneratorModel().createClass(pName, new Vector<GenClassModifier>(), (Type)product, comment, PackageConstants.PRODUCT_PACKAGE, "");
                        return new Tuple<GenType, Collection<ExceptionClassType>>(prod, new ArrayList());
                    }

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(SumType sum) throws TaskException {
                        GenType genType;
                        final ArrayList exceptions = new ArrayList();
                        ArrayList<Type> otherElements = new ArrayList<Type>();
                        for (Type current : sum.getElements()) {
                            if (current.isThrownType()) {
                                ThrownType thrownType = (ThrownType)current;
                                thrownType.getUnderlyingType().accept((TypeVisitorException)new TypeVisitorException<TaskException>(){

                                    public void handle(TypeProxy typeProxy) throws TaskException {
                                        throw new TaskException("TypeProxy cannot be the underlying type of a thrownType.");
                                    }

                                    public void handle(CompositeType compositeType) throws TaskException {
                                        throw new TaskException("CompositeType cannot be the underlying type of a thrownType.");
                                    }

                                    public void handle(AtomicType atomicType) throws TaskException {
                                        atomicType.accept((AtomicTypeVisitorException)new AtomicTypeVisitorException<TaskException>(){

                                            public void handle(ClassType clazz) throws TaskException {
                                                clazz.accept((ClassTypeVisitorException)new ClassTypeVisitorException<TaskException>(){

                                                    public void handle(ExceptionClassType exceptionClassType) throws TaskException {
                                                        exceptions.add(exceptionClassType);
                                                    }

                                                    public void handle(RegularClassType regularClassType) throws TaskException {
                                                        throw new TaskException("RegularClassType cannot be the underlying type of a thrownType.");
                                                    }
                                                });
                                            }

                                            public void handle(BaseType baseType) throws TaskException {
                                                throw new TaskException("BaseType cannot be the underlying type of a thrownType.");
                                            }
                                        });
                                    }
                                });
                                continue;
                            }
                            otherElements.add(current);
                        }
                        if (otherElements.size() == 0) {
                            genType = GenVoidType.getInstance();
                        } else if (otherElements.size() == 1) {
                            genType = (GenType)TypeTransformer.this.createGenType((Type)otherElements.iterator().next()).getA();
                        } else {
                            UnqualifiedName sumName = sum.equals((Object)TypeTransformer.this.getModel().getAnything().getPrototype()) ? TypeNameGenerator.getInstance().createName(TypeTransformer.ANYTHING_SUM_NAME) : TypeNameGenerator.getInstance().getTypeName((Type)sum);
                            GenComment comment = GenComment.createFromPlainText("", false);
                            GenInterfaceClass sumInterface = TypeTransformer.this.getGeneratorModel().createInterface(sumName.toString(), (Type)sum, comment, PackageConstants.SUM_PACKAGE, "");
                            if (sum.equals((Object)TypeTransformer.this.getModel().getAnything().getPrototype())) {
                                sumInterface.getImplement().add(GenExternalInterfaceClass.getInstance("de.fhdw.wtf.context.model.Anything"));
                            }
                            genType = sumInterface;
                        }
                        return new Tuple<GenType, Collection<ExceptionClassType>>(genType, exceptions);
                    }

                    public Tuple<GenType, Collection<ExceptionClassType>> handle(ThrownType thrownType) throws TaskException {
                        ArrayList<ExceptionClassType> list = new ArrayList<ExceptionClassType>();
                        if (thrownType.getUnderlyingType() instanceof ExceptionClassType) {
                            list.add((ExceptionClassType)thrownType.getUnderlyingType());
                        }
                        return new Tuple<GenType, Collection<ExceptionClassType>>(GenVoidType.getInstance(), list);
                    }
                });
            }

            public Tuple<GenType, Collection<ExceptionClassType>> handle(TypeProxy s) throws TaskException {
                return TypeTransformer.this.createGenType(UtilTransformer.getTypeProxyFreePrototype((Type)s));
            }
        });
    }

    private void changeAspectJInterfaceName() throws GenTypeNotReferencedException {
        for (Map.Entry<GenInterfaceClass, Type> current : this.getInterfaceString().entrySet()) {
            current.getKey().setName(this.getGeneratorModel().getGenTypeForType(current.getValue()).toString());
        }
    }

    private void changeDummyTypeMapType() throws GenTypeNotReferencedException {
        for (Map.Entry<GenMutableMap, MapType> current : this.mapTypeMapping.entrySet()) {
            GenType currentKey = this.getGeneratorModel().getGenTypeForType(current.getValue().getKey());
            GenType currentValue = this.getGeneratorModel().getGenTypeForType(current.getValue().getOf());
            current.getKey().setKey(currentKey);
            current.getKey().setType(currentValue);
        }
    }

    private void changeDummyTypeListType() throws GenTypeNotReferencedException {
        for (Map.Entry<GenCollectionType, ListType> current : this.listTypeMapping.entrySet()) {
            GenType currentValue = this.getGeneratorModel().getGenTypeForType(current.getValue().getOf());
            current.getKey().setType(currentValue);
        }
    }

    private GenType tryGetType(Type type) {
        GenType result;
        try {
            result = this.getGeneratorModel().getGenTypeForType(type);
        }
        catch (GenTypeNotReferencedException e) {
            return GenDummyType.create();
        }
        return result;
    }

    private boolean isInterface(Type type) {
        for (Type currentSuperType : type.getSuperTypes()) {
            if (this.isInterface(currentSuperType)) continue;
            return false;
        }
        return (Boolean)type.accept((TypeVisitorReturn)new TypeVisitorReturn<Boolean>(){

            public Boolean handle(AtomicType atomicType) {
                return (Boolean)atomicType.accept((AtomicTypeVisitorReturn)new AtomicTypeVisitorReturn<Boolean>(){

                    public Boolean handle(BaseType baseType) {
                        return false;
                    }

                    public Boolean handle(ClassType clazz) {
                        return clazz.isAbstract() && !TypeTransformer.this.hasAtLeastOneConcreteOperation(clazz) && clazz.getAttributes().isEmpty();
                    }
                });
            }

            public Boolean handle(CompositeType compositeType) {
                return (Boolean)compositeType.accept((CompositeTypeVisitorReturn)new CompositeTypeVisitorReturn<Boolean>(){

                    public Boolean handle(ListType list) {
                        return false;
                    }

                    public Boolean handle(MapType map) {
                        return false;
                    }

                    public Boolean handle(ProductType product) {
                        return false;
                    }

                    public Boolean handle(SumType sum) {
                        return true;
                    }

                    public Boolean handle(ThrownType thrownType) {
                        return false;
                    }
                });
            }

            public Boolean handle(TypeProxy typeProxy) {
                return TypeTransformer.this.isInterface(HelperUtils.getReferencedType((Type)typeProxy));
            }
        });
    }

    private boolean hasAtLeastOneConcreteOperation(ClassType clazz) {
        for (Operation current : clazz.getOperations()) {
            if (current.isAbstract()) continue;
            return true;
        }
        return false;
    }

    private Collection<GenClassModifier> handleClassModifier(Collection<ClassModifier> modifiers) {
        final Vector<GenClassModifier> modifier = new Vector<GenClassModifier>();
        for (ClassModifier current : modifiers) {
            current.accept(new ClassModifierVisitor(){

                public boolean handle(ClassModifierService service) {
                    return false;
                }

                public boolean handle(ClassModifierTransient tranzient) {
                    return true;
                }

                public boolean handle(ClassModifierAbstract abstract1) {
                    modifier.add(GenClassModifier.ABSTRACT);
                    return true;
                }

                public boolean handle(ClassModifierVisitable visitable) {
                    return true;
                }
            });
        }
        return modifier;
    }

    public GeneratorModel getGeneratorModel() {
        return this.genModel;
    }

    public Map<Tuple<GenType, Collection<ExceptionClassType>>, Type> getTypeMapping() {
        return this.typeMapping;
    }

    public UtilTransformer getUtilTransformer() {
        return this.utilTransformer;
    }

    public String toString() {
        return "Type Generation";
    }

    public Map<GenInterfaceClass, Type> getInterfaceString() {
        return this.interfaceString;
    }

    public void beginTask() throws TaskException {
        this.handleType((Type)this.getModel().getInteger());
        this.handleType((Type)this.getModel().getString());
    }

    public void finalizeTask() throws TaskException {
        this.handleType(this.getModel().getAnything().getPrototype());
        this.changeDummyTypeMapType();
        this.changeDummyTypeListType();
        this.changeAspectJInterfaceName();
    }
}

