/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.writer.writer;

import de.fhdw.wtf.file.FileUtils;
import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenAspect;
import de.fhdw.wtf.generator.java.generatorModel.GenAspectOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaException;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReference;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByReference;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitor;
import de.fhdw.wtf.generator.java.visitor.GenOperationVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenTypeReferenceVisitorReturn;
import de.fhdw.wtf.generator.writer.writer.ExceptionFileWriter;
import de.fhdw.wtf.generator.writer.writer.JavaClassFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.lang.NotImplementedException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class ClassFileWriter {
    static final String TARGED_CLASS_KEY = "targedClass";
    private static final String PACKAGE_KEY = "package";
    static final String PARAMETER_KEY = "parameter";
    private static final String CLASSNAME_KEY = "className";
    static final String PARSED_OPERATIONS_KEY = "parsedOperations";
    static final String SIMPLE_OPERATIONS_KEY = "simpleOperations";
    static final String VISIBILITY_KEY = "visibility";
    static final String MODIFIERS_KEY = "modifiers";
    static final String NAME_KEY = "name";
    private static final String ABSTRACT_KEY = "abstract";
    static final String TYP_KEY = "typ";
    private static final String RETURN_TYP_KEY = "returnTyp";
    static final String CLASS_MODIFIERS_KEY = "classModifiers";
    static final String METHOD_KEY = "method";
    private static final String NON_GERNATION_PART_KEY = "nonGenerationPart";
    private static final String CLASS_COMMENT_KEY = "classComment";
    private static final String OPERATION_COMMENT_KEY = "operationComment";
    static final String EXTENDS_KEY = "extends";
    private static final String IMPLEMENTS_KEY = "implements";
    static final String EXCEPTIONS_KEY = "exceptions";
    private static final String OPERATION_PARAMETER_KEY = "parameter";
    private static final String IMPORTS_KEY = "imports";
    static final String GENERICS_PARAMETER_KEY = "genericParam";
    static final String GENERICS_CLASS_KEY = "genericsClass";
    static final String GENERICS_OPERATION_KEY = "genericsOperation";
    static final String INNER_CLASSES_KEY = "innerClasses";
    static final String EXTENDS = "extends ";
    private static final String IMPLEMENTS = "implements ";
    private static final char PACKAGE_PATH_SEP = '.';
    private static final char JAVA_LINE_END = ';';
    private static final char FILE_PATH_SEP = '/';
    private static final String THROWS = "throws ";
    private static final String BLANK = " ";
    private static final String COMMA_SPARATE = ", ";
    private static final String GENERICS_BEGIN = "<";
    private static final String GENERICS_END = ">";
    private final VelocityEngine engine = new VelocityEngine();
    private final Template template;
    private final boolean fullyQualified;
    private Context currentContext;

    public ClassFileWriter(String templateFileName, boolean fullyQualified) {
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
        this.template = this.engine.getTemplate(templateFileName);
        this.fullyQualified = fullyQualified;
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    protected String typeToString(GenType type) {
        if (this.fullyQualified) {
            return type.getFullyQualifiedTypeNameWithGenericArguments();
        }
        return type.getName();
    }

    protected String typeToString(GenTypeReference typeReference) {
        return typeReference.accept(new GenTypeReferenceVisitorReturn<String>(){

            @Override
            public String handle(GenTypeReferenceByName typeReferenceByName) {
                return typeReferenceByName.getFullyQualifiedNameWithGenericArguments();
            }

            @Override
            public String handle(GenTypeReferenceByReference typeReferenceByReference) {
                return ClassFileWriter.this.typeToString(typeReferenceByReference.getTyp());
            }
        });
    }

    void writeClass(GenClass c) {
        this.currentContext = new VelocityContext();
        this.setUpContext(c, this.currentContext);
    }

    protected void writeToFile(GenClass c, File rootdir) {
        String result = this.generateFileContent(this.currentContext);
        File path = this.createPath(c, rootdir);
        File file = this.createFile(path, c);
        this.writeFile(result, path, file);
    }

    public String writeToString() {
        return this.generateFileContent(this.currentContext);
    }

    private void setUpContext(GenClass c, Context context) {
        this.setClassComment(c, context);
        this.setClassName(c, context);
        this.setClassGenerics(c, context);
        this.setImplements(c, context);
        this.setNonGenerationPart(c, context);
        this.setInnerClasses(c, context);
    }

    private void setClassGenerics(GenClass c, Context context) {
        StringBuilder gen = new StringBuilder();
        ListIterator<Generic> i = c.getGenerics().listIterator();
        if (i.hasNext()) {
            gen.append(GENERICS_BEGIN);
        }
        while (i.hasNext()) {
            Generic current = (Generic)i.next();
            gen.append(current.toString());
            if (i.hasNext()) {
                gen.append(COMMA_SPARATE);
                continue;
            }
            gen.append(GENERICS_END);
        }
        context.put(GENERICS_CLASS_KEY, (Object)gen.toString());
    }

    private void setClassComment(GenClass c, Context context) {
        context.put(CLASS_COMMENT_KEY, (Object)c.getComment().getText());
    }

    private void setClassName(GenClass c, Context context) {
        context.put(CLASSNAME_KEY, (Object)c.getName());
    }

    Collection<String> getSimpleOperations(Collection<? extends GenOperation> operations) {
        final Vector<String> simpleOperations = new Vector<String>();
        for (GenOperation genOperation : operations) {
            genOperation.getState().accept(new GenOperationStateVisitor(){

                @Override
                public void handle(GenFullParsedOperationState s) {
                }

                @Override
                public void handle(GenSimpleOperationState s) {
                    simpleOperations.add(s.getFullOperationWithPossibleImplementation());
                }
            });
        }
        return simpleOperations;
    }

    Collection<HashMap<String, Object>> getParsedOperations(Collection<? extends GenOperation> operations) {
        final Vector<HashMap<String, Object>> parsedOperations = new Vector<HashMap<String, Object>>();
        for (final GenOperation genOperation : operations) {
            genOperation.getState().accept(new GenOperationStateVisitor(){

                @Override
                public void handle(GenFullParsedOperationState s) {
                    final HashMap<String, Object> current = new HashMap<String, Object>();
                    current.put(ClassFileWriter.VISIBILITY_KEY, s.getVisibility().toString());
                    current.put(ClassFileWriter.NAME_KEY, genOperation.getName());
                    current.put(ClassFileWriter.RETURN_TYP_KEY, ClassFileWriter.this.typeToString(s.getReturntyp()));
                    s.getModifiers().remove((Object)GenOperationModifier.ABSTRACT);
                    Vector<String> modifiers = new Vector<String>();
                    for (GenOperationModifier mod : s.getModifiers()) {
                        modifiers.add(mod.toString());
                    }
                    current.put(ClassFileWriter.GENERICS_OPERATION_KEY, ClassFileWriter.this.getGenericString(genOperation));
                    current.put(ClassFileWriter.MODIFIERS_KEY, modifiers);
                    current.put(ClassFileWriter.METHOD_KEY, s.getMethodBody());
                    current.put(ClassFileWriter.OPERATION_COMMENT_KEY, s.getComment().getText());
                    current.put("parameter", ClassFileWriter.this.getParamString(genOperation.getParameters()));
                    current.put(ClassFileWriter.EXCEPTIONS_KEY, ClassFileWriter.this.getExceptionString(s.getExceptions()));
                    genOperation.accept(new GenOperationVisitorReturn<GenOperation>(){

                        @Override
                        public GenOperation handleJavaOperation(GenJavaOperation operation) {
                            return operation;
                        }

                        @Override
                        public GenOperation handleAspectOperation(GenAspectOperation operation) {
                            current.put(ClassFileWriter.TARGED_CLASS_KEY, ClassFileWriter.this.typeToString(operation.getOwner()) + ".");
                            return operation;
                        }
                    });
                    parsedOperations.add(current);
                }

                @Override
                public void handle(GenSimpleOperationState s) {
                }
            });
        }
        return parsedOperations;
    }

    private String getGenericString(GenOperation operation) {
        StringBuilder gen = new StringBuilder();
        ListIterator<Generic> i = operation.getGenerics().listIterator();
        if (i.hasNext()) {
            gen.append(GENERICS_BEGIN);
        }
        while (i.hasNext()) {
            Generic current = (Generic)i.next();
            String generic = "";
            generic = generic + current.toString();
            gen.append(generic);
            if (i.hasNext()) {
                gen.append(COMMA_SPARATE);
                continue;
            }
            gen.append(GENERICS_END);
        }
        return gen.toString();
    }

    protected String getExceptionString(Collection<GenException> exceptions) {
        if (exceptions.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(THROWS);
        Iterator<GenException> i = exceptions.iterator();
        while (i.hasNext()) {
            GenException current = i.next();
            result.append(this.typeToString(current));
            if (!i.hasNext()) continue;
            result.append(COMMA_SPARATE);
        }
        return result.toString();
    }

    protected String getParamString(Collection<GenParameter> parameters) {
        StringBuilder params = new StringBuilder();
        Iterator<GenParameter> i = parameters.iterator();
        while (i.hasNext()) {
            GenParameter current = i.next();
            params.append(this.typeToString(current.getTyp()));
            ListIterator<Generic> iGen = current.getGenerics().listIterator();
            if (iGen.hasNext()) {
                params.append(GENERICS_BEGIN);
            }
            while (iGen.hasNext()) {
                Generic currentGen = (Generic)iGen.next();
                params.append(currentGen.getName());
                if (iGen.hasNext()) {
                    params.append(COMMA_SPARATE);
                    continue;
                }
                params.append(GENERICS_END);
            }
            params.append(BLANK);
            params.append(current.getName());
            if (!i.hasNext()) continue;
            params.append(COMMA_SPARATE);
        }
        return params.toString();
    }

    private void setNonGenerationPart(GenClass c, Context context) {
        context.put(NON_GERNATION_PART_KEY, (Object)c.getNonGeneratedPart());
    }

    private File createPath(GenClass c, File rootDir) {
        String path = c.getPackag().toString();
        path = path.replace('.', '/');
        path = path.replace(';', '/');
        return new File(rootDir.getAbsolutePath() + '/' + path);
    }

    private File createFile(File path, GenClass c) {
        String file = path.getAbsolutePath() + '/' + c.getName() + c.getFileEnding();
        return new File(file);
    }

    private void writeFile(String result, File path, File file) {
        try {
            System.out.println("  -->  " + file.getAbsolutePath());
            FileUtils.overrideToFile(result, path, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String generateFileContent(Context context) {
        StringWriter writer = new StringWriter();
        this.template.merge(context, (Writer)writer);
        return writer.toString();
    }

    public abstract String getStringContent(GenClass var1);

    protected void setImplements(GenClass c, final Context context) {
        final StringBuilder implsS = new StringBuilder();
        Iterator<GenInterfaceClass> i = c.getImplement().iterator();
        while (i.hasNext()) {
            GenInterfaceClass current = i.next();
            implsS.append(this.typeToString(current));
            if (!i.hasNext()) continue;
            implsS.append(COMMA_SPARATE);
        }
        if (!c.getImplement().isEmpty()) {
            c.accept(new GenClassVisitor(){

                @Override
                public void handle(GenInterfaceClass interfaceClass) {
                    context.put(ClassFileWriter.IMPLEMENTS_KEY, (Object)(ClassFileWriter.EXTENDS + implsS.toString()));
                }

                @Override
                public void handle(GenClassClass classClass) {
                    context.put(ClassFileWriter.IMPLEMENTS_KEY, (Object)(ClassFileWriter.IMPLEMENTS + implsS.toString()));
                }

                @Override
                public void handle(GenPrimitiveClass primitiveClass) {
                }
            });
        } else {
            context.put(IMPLEMENTS_KEY, (Object)"");
        }
    }

    private void setInnerClasses(GenClass c, Context context) {
        Vector<String> innerClassesCollection = new Vector<String>();
        Iterator<GenClassClass> innerClassesIterator = c.getInnerClasses().iterator();
        boolean subclassesFullyQualified = true;
        while (innerClassesIterator.hasNext()) {
            GenClassClass current = innerClassesIterator.next();
            String innerClassAsString = current.accept(new GenClassClassVisitorReturn<String>(){

                @Override
                public String handle(GenException e) {
                    ExceptionFileWriter subExceptionClassFileWriter = new ExceptionFileWriter(true);
                    return subExceptionClassFileWriter.getStringContent(e);
                }

                @Override
                public String handle(GenAnyType anyType) {
                    throw new NotImplementedException();
                }

                @Override
                public String handle(GenJavaException javaE) {
                    throw new NotImplementedException();
                }

                @Override
                public String handle(GenUserClass userclass) {
                    JavaClassFileWriter subClassFileWriter = new JavaClassFileWriter(true);
                    return subClassFileWriter.getStringContent(userclass);
                }

                @Override
                public String handle(GenAspect aspect) {
                    throw new NotImplementedException();
                }

                @Override
                public String handle(GenExternalClassClass externalClass) {
                    throw new NotImplementedException();
                }
            });
            innerClassesCollection.add(innerClassAsString);
        }
        context.put(INNER_CLASSES_KEY, innerClassesCollection);
    }
}

