/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.ConstructorOrOperation;
import de.fhdw.wtf.common.ast.Group;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenExternalInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceWithClassImplClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReference;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenInterfaceClassVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenOperationStateVisitorReturnException;
import de.fhdw.wtf.generator.transformer.exception.GenTypeNotReferencedException;
import de.fhdw.wtf.walker.walker.SimpleWalkerTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DelegationTransformer
extends SimpleWalkerTask {
    private final GeneratorModel generatorModel;

    public DelegationTransformer(Model m, TaskExecutor taskmanager, GeneratorModel generatorModel) {
        super(m, taskmanager);
        this.generatorModel = generatorModel;
    }

    public void handleClass(final ClassType c) throws TaskException {
        GenClass clazz = this.generatorModel.getJavaClassForWTFClass((Type)c);
        clazz.accept(new GenClassVisitorException<TaskException>(){

            @Override
            public void handle(GenClassClass classClass) throws GenTypeNotReferencedException {
            }

            @Override
            public void handle(GenInterfaceClass interfaceClass) throws TaskException {
                interfaceClass.accept(new GenInterfaceClassVisitorException<TaskException>(){

                    @Override
                    public void handle(GenSimpleInterfaceClass simpleInterface) throws GenTypeNotReferencedException {
                    }

                    @Override
                    public void handle(GenInterfaceWithClassImplClass interfaceWithImplClass) throws TaskException {
                        if (DelegationTransformer.this.isInterfaceInheritanceRoot(interfaceWithImplClass)) {
                            DelegationTransformer.this.handleInheritanceRoot(interfaceWithImplClass.getClassRepresentation());
                        }
                        DelegationTransformer.this.makeDelegations(c, interfaceWithImplClass.getClassRepresentation());
                    }

                    @Override
                    public void handle(GenExternalInterfaceClass iface) throws GenTypeNotReferencedException {
                    }
                });
            }

            @Override
            public void handle(GenPrimitiveClass primitiveClass) throws GenTypeNotReferencedException {
            }
        });
    }

    private void handleInheritanceRoot(GenUserClass classRepresentation) throws TaskException {
        for (GenJavaOperation genJavaOperation : classRepresentation.getOperations()) {
            GenJavaOperation operation;
            String name = genJavaOperation.getName();
            List<GenParameter> parameters = genJavaOperation.getParameters();
            GenComment comment = this.getComment(genJavaOperation);
            Collection<GenException> exceptions = this.getExceptions(genJavaOperation);
            GenTypeReference returntyp = this.getReturnType(genJavaOperation);
            Collection<GenOperationModifier> modifiers = this.getModifiers(genJavaOperation);
            GenVisibility visibility = this.getVisibility(genJavaOperation);
            if (name.contains("$") || name.equals("accept")) continue;
            boolean isAbstract = modifiers.contains((Object)GenOperationModifier.ABSTRACT);
            if (isAbstract) {
                operation = this.makeAbstractOperation(name, parameters, comment, exceptions, returntyp, modifiers, visibility, genJavaOperation.getGenerics());
                operation.getGenerics().addAll(genJavaOperation.getGenerics());
                classRepresentation.overrideExistingOperation(operation);
                continue;
            }
            operation = this.makeConcreteOperationEmpty(name, parameters, comment, exceptions, returntyp, modifiers, visibility, genJavaOperation.getGenerics());
            operation.getGenerics().addAll(genJavaOperation.getGenerics());
            classRepresentation.overrideExistingOperation(operation);
        }
    }

    private void makeDelegations(ClassType c, GenUserClass classRepresentation) throws TaskException {
        for (GenJavaOperation genJavaOperation : classRepresentation.getOperations()) {
            String name = genJavaOperation.getName();
            Collection<GenOperationModifier> modifiers = this.getModifiers(genJavaOperation);
            if (name.contains("$")) continue;
            boolean isAbstract = modifiers.contains((Object)GenOperationModifier.ABSTRACT);
            for (ClassType subType : c.getSubTypes()) {
                GenClassClass genSubClass = this.getRepresentingClass(this.generatorModel.getJavaClassForWTFClass((Type)subType));
                boolean sameNameFound = false;
                Iterator<GenJavaOperation> i2 = genSubClass.getOperations().iterator();
                while (!sameNameFound && i2.hasNext()) {
                    GenJavaOperation genJavaOperation2 = i2.next();
                    if (genJavaOperation.getName().equals("accept")) {
                        sameNameFound = genJavaOperation2.toString().equals(genJavaOperation.toString());
                        continue;
                    }
                    sameNameFound = genJavaOperation2.getName().equals(genJavaOperation.getName());
                }
                this.addDelegationsInSubClass(subType, genSubClass, classRepresentation, genJavaOperation, isAbstract, sameNameFound);
            }
        }
    }

    private void addDelegationsInSubClass(ClassType subType, GenClassClass sub, GenUserClass superType, GenJavaOperation genJavaOperation, boolean isAbstract, boolean same) throws TaskException {
        GenJavaOperation operation = null;
        if (subType.isAbstract()) {
            if (isAbstract) {
                operation = this.makeAbstractOperation(genJavaOperation);
            } else {
                operation = this.makeOperationWithDelegationToSuper(superType, genJavaOperation);
                this.getModifiers(operation).remove((Object)GenOperationModifier.ABSTRACT);
            }
        } else if (isAbstract) {
            operation = this.makeConcreteOperationEmpty(genJavaOperation);
            this.getModifiers(operation).remove((Object)GenOperationModifier.ABSTRACT);
        } else {
            operation = this.makeOperationWithDelegationToSuper(superType, genJavaOperation);
            this.getModifiers(operation).remove((Object)GenOperationModifier.ABSTRACT);
        }
        if (same) {
            sub.overrideExistingOperation(operation);
        } else {
            sub.addOperation(operation);
        }
    }

    private GenClassClass getRepresentingClass(GenClass javaClass) throws TaskException {
        GenClassClass classClass = javaClass.accept(new GenClassVisitorReturn<GenClassClass>(){

            @Override
            public GenClassClass handle(GenClassClass genClassClass) {
                return null;
            }

            @Override
            public GenClassClass handle(GenInterfaceClass interfaceClass) {
                return interfaceClass.accept(new GenInterfaceClassVisitorReturn<GenClassClass>(){

                    @Override
                    public GenClassClass handle(GenSimpleInterfaceClass simpleInterface) {
                        return null;
                    }

                    @Override
                    public GenClassClass handle(GenInterfaceWithClassImplClass interfaceWithImplClass) {
                        return interfaceWithImplClass.getClassRepresentation();
                    }

                    @Override
                    public GenClassClass handle(GenExternalInterfaceClass iface) {
                        return null;
                    }
                });
            }

            @Override
            public GenClassClass handle(GenPrimitiveClass primitiveClass) {
                return null;
            }
        });
        if (classClass == null) {
            throw new TaskException("Subclass is not a GenInterfaceWithGenClass!");
        }
        return classClass;
    }

    private GenJavaOperation makeOperationWithDelegationToSuper(GenUserClass superType, GenJavaOperation genJavaOperation) throws TaskException {
        String name = genJavaOperation.getName();
        List<GenParameter> parameters = genJavaOperation.getParameters();
        GenComment comment = this.getComment(genJavaOperation);
        Collection<GenException> exceptions = this.getExceptions(genJavaOperation);
        GenTypeReference returntyp = this.getReturnType(genJavaOperation);
        Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
        modifiers.addAll(this.getModifiers(genJavaOperation));
        GenVisibility visibility = this.getVisibility(genJavaOperation);
        return this.makeOperationWithDelegationToSuper(superType, name, parameters, comment, exceptions, returntyp, modifiers, visibility, genJavaOperation.getGenerics());
    }

    private GenJavaOperation makeOperationWithDelegationToSuper(GenUserClass superType, String name, List<GenParameter> parameters, GenComment comment, Collection<GenException> exceptions, GenTypeReference returntyp, Collection<GenOperationModifier> modifiers, GenVisibility visibility, List<Generic> generics) {
        String superTypeName = superType.getFullyQualifiedTypeName();
        boolean isVoid = returntyp.getFullyQualifiedName().equals("void");
        String returnString = isVoid ? "" : "return ";
        String methodBody = returnString + "((" + superTypeName + ")this.$generatedObjects.get(new de.fhdw.wtf.context.model.Str(\"" + superTypeName + "\")))." + name + "(" + this.generateParameterNamesList(parameters) + ");";
        GenFullParsedOperationState state = GenFullParsedOperationState.create(comment, exceptions, returntyp, modifiers, visibility, methodBody);
        GenJavaOperation operation = GenJavaOperation.create(name, parameters, state);
        operation.getGenerics().addAll(generics);
        return operation;
    }

    private String generateParameterNamesList(List<GenParameter> parameters) {
        StringBuilder parameterStringBuilder = new StringBuilder();
        for (GenParameter p : parameters) {
            parameterStringBuilder.append(", ");
            parameterStringBuilder.append(p.getName());
        }
        String parameterNamesList = parameterStringBuilder.toString();
        if (parameterNamesList.length() > 0) {
            parameterNamesList = parameterNamesList.replaceFirst(", ", "");
        }
        return parameterNamesList;
    }

    private GenJavaOperation makeConcreteOperationEmpty(GenJavaOperation genJavaOperation) throws TaskException {
        String name = genJavaOperation.getName();
        List<GenParameter> parameters = genJavaOperation.getParameters();
        GenComment comment = this.getComment(genJavaOperation);
        Collection<GenException> exceptions = this.getExceptions(genJavaOperation);
        GenTypeReference returntyp = this.getReturnType(genJavaOperation);
        Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
        modifiers.addAll(this.getModifiers(genJavaOperation));
        GenVisibility visibility = this.getVisibility(genJavaOperation);
        return this.makeConcreteOperationEmpty(name, parameters, comment, exceptions, returntyp, modifiers, visibility, genJavaOperation.getGenerics());
    }

    private GenJavaOperation makeConcreteOperationEmpty(String name, List<GenParameter> parameters, GenComment comment, Collection<GenException> exceptions, GenTypeReference returntyp, Collection<GenOperationModifier> modifiers, GenVisibility visibility, List<Generic> generics) {
        String methodBody = "";
        methodBody = name.equals("accept") ? "visitor.handle(this);" : "//TODO implement operation " + name + (returntyp.getFullyQualifiedName().equals("void") ? "" : "\n\t\treturn null;");
        GenFullParsedOperationState state = GenFullParsedOperationState.create(comment, exceptions, returntyp, modifiers, visibility, methodBody);
        GenJavaOperation operation = GenJavaOperation.create(name, parameters, state);
        operation.getGenerics().addAll(generics);
        return operation;
    }

    private GenJavaOperation makeAbstractOperation(GenJavaOperation genJavaOperation) throws TaskException {
        String name = genJavaOperation.getName();
        List<GenParameter> parameters = genJavaOperation.getParameters();
        GenComment comment = this.getComment(genJavaOperation);
        Collection<GenException> exceptions = this.getExceptions(genJavaOperation);
        GenTypeReference returntyp = this.getReturnType(genJavaOperation);
        Vector<GenOperationModifier> modifiers = new Vector<GenOperationModifier>();
        modifiers.addAll(this.getModifiers(genJavaOperation));
        GenVisibility visibility = this.getVisibility(genJavaOperation);
        return this.makeAbstractOperation(name, parameters, comment, exceptions, returntyp, modifiers, visibility, genJavaOperation.getGenerics());
    }

    private GenJavaOperation makeAbstractOperation(String name, List<GenParameter> parameters, GenComment comment, Collection<GenException> exceptions, GenTypeReference returntyp, Collection<GenOperationModifier> modifiers, GenVisibility visibility, List<Generic> generics) {
        String methodBody = "if(this.$getThis()==this)throw new Error();\n\t\t" + (returntyp.getFullyQualifiedName().equals("void") ? "" : "return ") + "this.$getThis()." + name + "();";
        GenFullParsedOperationState state = GenFullParsedOperationState.create(comment, exceptions, returntyp, modifiers, visibility, methodBody);
        GenJavaOperation operation = GenJavaOperation.create(name, parameters, state);
        operation.getGenerics().addAll(generics);
        return operation;
    }

    private boolean isInterfaceInheritanceRoot(GenInterfaceWithClassImplClass checkInterface) throws GenTypeNotReferencedException {
        return checkInterface.getImplement().contains(this.generatorModel.getGenTypeForType((Type)this.getModel().getAnything()));
    }

    public void handleGroup(Group g) throws TaskException {
    }

    public void handleAttribute(Attribute a, ClassType owner) throws TaskException {
    }

    public void handleConstructorOrOperation(ConstructorOrOperation coo, ClassType owner) throws TaskException {
    }

    public void finalizeTask() throws TaskException {
    }

    private GenVisibility getVisibility(GenJavaOperation genJavaOperation) throws TaskException {
        return genJavaOperation.getState().accept(new GenOperationStateVisitorReturnException<GenVisibility, TaskException>(){

            @Override
            public GenVisibility handle(GenSimpleOperationState s) throws TaskException {
                throw new TaskException("Wrong state for operation");
            }

            @Override
            public GenVisibility handle(GenFullParsedOperationState s) {
                return s.getVisibility();
            }
        });
    }

    private Collection<GenOperationModifier> getModifiers(GenJavaOperation genJavaOperation) throws TaskException {
        return genJavaOperation.getState().accept(new GenOperationStateVisitorReturnException<Collection<GenOperationModifier>, TaskException>(){

            @Override
            public Collection<GenOperationModifier> handle(GenSimpleOperationState s) throws TaskException {
                throw new TaskException("Wrong state for operation");
            }

            @Override
            public Collection<GenOperationModifier> handle(GenFullParsedOperationState s) {
                return s.getModifiers();
            }
        });
    }

    private GenTypeReference getReturnType(GenJavaOperation genJavaOperation) throws TaskException {
        return genJavaOperation.getState().accept(new GenOperationStateVisitorReturnException<GenTypeReference, TaskException>(){

            @Override
            public GenTypeReference handle(GenSimpleOperationState s) throws TaskException {
                throw new TaskException("Wrong state for operation");
            }

            @Override
            public GenTypeReference handle(GenFullParsedOperationState s) {
                return s.getReturntyp();
            }
        });
    }

    private GenComment getComment(GenJavaOperation genJavaOperation) throws TaskException {
        return genJavaOperation.getState().accept(new GenOperationStateVisitorReturnException<GenComment, TaskException>(){

            @Override
            public GenComment handle(GenSimpleOperationState s) throws TaskException {
                throw new TaskException("Wrong state for operation");
            }

            @Override
            public GenComment handle(GenFullParsedOperationState s) {
                return s.getComment();
            }
        });
    }

    private Collection<GenException> getExceptions(GenJavaOperation genJavaOperation) throws TaskException {
        return genJavaOperation.getState().accept(new GenOperationStateVisitorReturnException<Collection<GenException>, TaskException>(){

            @Override
            public Collection<GenException> handle(GenSimpleOperationState s) throws TaskException {
                throw new TaskException("Wrong state for operation");
            }

            @Override
            public Collection<GenException> handle(GenFullParsedOperationState s) {
                return s.getExceptions();
            }
        });
    }

    public void beginTask() throws TaskException {
    }
}

