/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.transformer.transformers.classTransformer;

import de.fhdw.wtf.common.ast.Attribute;
import de.fhdw.wtf.common.ast.Model;
import de.fhdw.wtf.common.ast.type.AtomicType;
import de.fhdw.wtf.common.ast.type.BaseType;
import de.fhdw.wtf.common.ast.type.ClassType;
import de.fhdw.wtf.common.ast.type.CompositeType;
import de.fhdw.wtf.common.ast.type.ExceptionClassType;
import de.fhdw.wtf.common.ast.type.Type;
import de.fhdw.wtf.common.ast.type.TypeProxy;
import de.fhdw.wtf.common.ast.visitor.AtomicTypeVisitor;
import de.fhdw.wtf.common.ast.visitor.TypeVisitor;
import de.fhdw.wtf.common.exception.walker.TaskException;
import de.fhdw.wtf.common.task.TaskExecutor;
import de.fhdw.wtf.generator.java.generatorModel.GenAnyType;
import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenClassModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenComment;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenFullParsedOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenHasGenericType;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaAttribute;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;
import de.fhdw.wtf.generator.java.generatorModel.GenOperationModifier;
import de.fhdw.wtf.generator.java.generatorModel.GenPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenParameter;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenSimpleOperationState;
import de.fhdw.wtf.generator.java.generatorModel.GenType;
import de.fhdw.wtf.generator.java.generatorModel.GenTypeReferenceByName;
import de.fhdw.wtf.generator.java.generatorModel.GenUnqualifiedPackage;
import de.fhdw.wtf.generator.java.generatorModel.GenUserClass;
import de.fhdw.wtf.generator.java.generatorModel.GenVisibility;
import de.fhdw.wtf.generator.java.generatorModel.GeneratorModel;
import de.fhdw.wtf.generator.java.generatorModel.Generic;
import de.fhdw.wtf.generator.transformer.transformers.classTransformer.TypeTransformer;
import de.fhdw.wtf.generator.transformer.util.Tuple;
import java.util.Collection;
import java.util.Vector;

public class InnerClassCreatorForSymmetricAttributesTransformer
extends TypeTransformer {
    private static final String SETOPERATIONNAME = "set";
    private static final String SYMMETRICSETTERINTERFACENAME = "Setter";
    private GenClass setterInterface;

    public InnerClassCreatorForSymmetricAttributesTransformer(Model model, TaskExecutor taskmanager, GeneratorModel generatorModel) {
        super(model, taskmanager, generatorModel);
    }

    @Override
    public void finalizeTask() throws TaskException {
    }

    @Override
    public void beginTask() throws TaskException {
        this.setterInterface = this.getSymmetrySetterInterface();
        this.getGeneratorModel().setSymmetricSetterInterface(this.setterInterface);
    }

    @Override
    public void handleType(Type c) throws TaskException {
        c.accept(new TypeVisitor(){

            public void handle(TypeProxy typeProxy) {
            }

            public void handle(CompositeType compositeType) {
            }

            public void handle(AtomicType atomicType) {
                atomicType.accept(new AtomicTypeVisitor(){

                    public void handle(ClassType clazz) {
                        try {
                            InnerClassCreatorForSymmetricAttributesTransformer.this.addprivateSetterInterfaceIfNecessary(clazz);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void handle(BaseType baseType) {
                    }
                });
            }
        });
    }

    protected void addprivateSetterInterfaceIfNecessary(ClassType classType) throws Exception {
        for (Attribute a : classType.getAttributes()) {
            if (!a.isSymmetric()) continue;
            this.addInnerSetterClassToImplClass(classType, a);
        }
    }

    private void addInnerSetterClassToImplClass(ClassType classType, Attribute attribute) throws Exception {
        for (Tuple<GenType, Collection<ExceptionClassType>> key : this.getTypeMapping().keySet()) {
            if (!this.getTypeMapping().get(key).equals((Object)classType)) continue;
            ((GenClassClass)key.getA()).addInnerClass(this.getInnerStaticClassByAttribute((GenClassClass)key.getA(), attribute));
            return;
        }
        throw new Exception("no *$Impl-Class found");
    }

    private GenClassClass getInnerStaticClassByAttribute(GenClassClass aImplClass, Attribute attribute) {
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        operations.add(this.getOperationImplementation(aImplClass, attribute));
        Vector<GenInterfaceClass> implement = new Vector<GenInterfaceClass>();
        implement.add((GenInterfaceClass)this.setterInterface);
        Vector<GenClassModifier> modifiers = new Vector<GenClassModifier>();
        modifiers.add(GenClassModifier.STATIC);
        Vector<GenJavaOperation> constructors = new Vector<GenJavaOperation>();
        String nonGeneratedPart = "";
        Vector<GenJavaAttribute> attributes = new Vector<GenJavaAttribute>();
        GenComment comment = GenComment.create("Setter Implementation for symmetric attributes");
        GenUserClass result = GenUserClass.create(attribute.getName() + SYMMETRICSETTERINTERFACENAME, operations, implement, attributes, modifiers, constructors, null, null, comment, "");
        return result;
    }

    private GenJavaOperation getOperationImplementation(GenClassClass genClassClass, Attribute attribute) {
        String methodbody = "owner." + attribute.getAttrType().getTypeString() + " = target;";
        Vector<GenParameter> parameters = new Vector<GenParameter>();
        parameters.add(GenParameter.create("owner", genClassClass));
        parameters.add(GenParameter.create("target", GenTypeReferenceByName.create(attribute.getAttrType().getTypeString())));
        GenJavaOperation result = GenJavaOperation.create(SETOPERATIONNAME, parameters, GenFullParsedOperationState.create(GenComment.create(""), new Vector<GenException>(), GenTypeReferenceByName.create(""), new Vector<GenOperationModifier>(), GenVisibility.PUBLIC, methodbody));
        return result;
    }

    private Generic getGenericForSetterInterface(String nameOfType) {
        return Generic.create(nameOfType, GenHasGenericType.create(GenAnyType.getInstance()));
    }

    private GenJavaOperation getOperationForSetterInterface(String name) {
        Vector<GenParameter> parameters = new Vector<GenParameter>();
        parameters.add(GenParameter.create(name, this.getGenericForSetterInterface(name.toUpperCase())));
        GenJavaOperation result = GenJavaOperation.create(name, parameters, GenSimpleOperationState.create(""));
        return result;
    }

    private GenSimpleInterfaceClass getSymmetrySetterInterface() {
        Vector<GenJavaOperation> operations = new Vector<GenJavaOperation>();
        GenPackage classPackage = GenUnqualifiedPackage.create("generated");
        classPackage = ((GenPackage)classPackage).addName("symmetry");
        operations.add(this.getOperationForSetterInterface(SETOPERATIONNAME));
        GenSimpleInterfaceClass result = GenSimpleInterfaceClass.create(SYMMETRICSETTERINTERFACENAME, operations, new Vector<GenInterfaceClass>(), classPackage, GenComment.create("Represents an interface for the setter for symmetric attributes."), "");
        result.getGenerics().add(this.getGenericForSetterInterface("T1"));
        result.getGenerics().add(this.getGenericForSetterInterface("T2"));
        return result;
    }

    @Override
    public String toString() {
        return "InnerClassCreatorForSymmetricAttributesTransformer";
    }
}

