package de.fhdw.wtf.generator.java.generatorModel;

import de.fhdw.wtf.generator.java.visitor.GenTypeVisitor;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorException;
import de.fhdw.wtf.generator.java.visitor.GenTypeVisitorReturn;
import de.fhdw.wtf.generator.java.visitor.GenerationModelItemVisitor;

/**
 * A GenType represents some type in Java-syntax. This can for example be a class, an import or a map.
 */
public abstract class GenType extends GenerationModelItem {
	
	/**
	 * Instantiates a new GenType.
	 * 
	 * @param name
	 *            The name of the GenType.
	 */
	protected GenType(final String name) {
		super(name);
	}
	
	/**
	 * Returns the fully qualified name that includes the package information.
	 * 
	 * @return String
	 */
	public abstract String getFullyQualifiedTypeName();
	
	/**
	 * Returns the fully qualified name that includes the package information and generic type arguments (if any).
	 * 
	 * @return String
	 */
	public abstract String getFullyQualifiedTypeNameWithGenericArguments();
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 */
	public abstract void accept(GenTypeVisitor visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <X>
	 *            The returntype of the handle and the accept method.
	 * @return Returns the result of type <X> that is returned by the handle method.
	 */
	public abstract <X> X accept(GenTypeVisitorReturn<X> visitor);
	
	/**
	 * Calls the handle method in the given visitor.
	 * 
	 * @param visitor
	 *            The visitor to handle this type.
	 * @param <Y>
	 *            The exception that can be thrown by the handle method.
	 * @throws Y
	 *             Throws an exception of type <X> when the handle method throws it.
	 */
	public abstract <Y extends java.lang.Exception> void accept(GenTypeVisitorException<Y> visitor) throws Y;
	
	@Override
	public void accept(final GenerationModelItemVisitor visitor) {
		visitor.handle(this);
	}
	
}
