package de.fhdw.wtf.generator.writer.writer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.velocity.context.Context;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenException;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaOperation;

/**
 * Generate {@link GenException} classes whilst transferring form java model to generated Java application.
 */
public class ExceptionFileWriter extends ClassClassFileWriter {
	
	/**
	 * Creates a new ExceptionFileWriter.
	 * 
	 * @param fullyQualified
	 *            Boolean parameter. If value is {@code true}: Generate fully qualified name including package name for
	 *            Types. If value is {@code false} Generate simple name for Types without package name.
	 */
	public ExceptionFileWriter(final boolean fullyQualified) {
		super(TEMPLATE_FILE_NAME, fullyQualified);
	}
	
	private static final String TEMPLATE_FILE_NAME = "de/fhdw/wtf/generator/templates/modelclass.vm";
	
	private void setUpContext(final GenException exceptionClass, final Context currentContext) {
		this.setAttributes(exceptionClass, currentContext);
		this.setOperations(exceptionClass, currentContext);
	}
	
	private void setOperations(final GenException exceptionClass, final Context currentContext) {
		currentContext.put(PARSED_OPERATIONS_KEY, this.getParsedOperations(exceptionClass.getOperations()));
		final Collection<GenJavaOperation> operationsWithSimple = new ArrayList<>();
		operationsWithSimple.addAll(exceptionClass.getOperations());
		operationsWithSimple.addAll(exceptionClass.getConstructors());
		currentContext.put(SIMPLE_OPERATIONS_KEY, this.getSimpleOperations(operationsWithSimple));
	}
	
	/**
	 * Writes the file for the given {@link de.fhdw.wtf.generator.java.generatorModel.GenException}
	 * {@code exceptionClass}.
	 * 
	 * @param exceptionClass
	 *            Exception to write the file for
	 */
	public void writeJavaExceptionClass(final GenException exceptionClass, final File rootdir) {
		this.writeClassClass(exceptionClass);
		this.setUpContext(exceptionClass, this.getCurrentContext());
		this.writeToFile(exceptionClass, rootdir);
	}
	
	/**
	 * Writes the given {@link GenException} exception to a String.
	 * 
	 * @param exceptionClass
	 *            The class to write.
	 * @return A String representation of the GenException in java-syntax.
	 */
	public String writeJavaExceptionClassToString(final GenException exceptionClass) {
		this.writeClassClass(exceptionClass);
		this.setUpContext(exceptionClass, this.getCurrentContext());
		return this.writeToString();
	}
	
	/**
	 * Sets all values for the attribute declaration of {@link de.fhdw.wtf.generator.java.generatorModel.GenException}
	 * {@code exceptionClass} to the {@link Context}.
	 * 
	 * @param exceptionClass
	 * @param currentContext
	 */
	private void setAttributes(final GenException exceptionClass, final Context currentContext) {
		currentContext.put(ATTRIBUTES_KEY, this.getAttributes(exceptionClass.getAttributes()));
	}
	
	@Override
	public String getStringContent(final GenClass clazz) {
		final GenException clazzAsGenException = (GenException) clazz;
		this.writeClassClass(clazzAsGenException);
		this.setUpContext(clazzAsGenException, this.getCurrentContext());
		return this.writeToString();
	}
}
