/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.generator.database.generation;

import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.OracleClassFacadeImplementation;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.TypeVisitorReturnException;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import java.util.HashMap;
import java.util.Map;

public class InitialGenerator {
    private final ClassFacade classFacade = new OracleClassFacadeImplementation(OracleDatabaseManager.getInstance());
    private final Map<String, Type> types;

    public InitialGenerator() throws PersistenceException {
        this.classFacade.initialize();
        this.types = new HashMap<String, Type>();
    }

    public Type mapNameToType(String typeName) {
        return this.types.get(typeName);
    }

    public UserType createClass(String className, boolean abs, boolean trans) throws PersistenceException {
        UserType result = this.classFacade.createUserType(className, abs, trans);
        this.types.put(className, (Type)result);
        return result;
    }

    public UnidirectionalAssociation createUnidirectionalAssociation(String name, boolean essential, boolean unique, long source, long target) throws PersistenceException {
        Type s1 = this.classFacade.getTypeManager().getTypeForId(source);
        UserType s = (UserType)s1.accept((TypeVisitorReturnException)new TypeVisitorReturnException<UserType, TypeOrAssociationNotFoundException>(){

            public UserType handleUserType(UserType t) {
                return t;
            }

            public UserType handleBaseType(Type t) throws TypeOrAssociationNotFoundException {
                throw new TypeOrAssociationNotFoundException(t.getId());
            }
        });
        Type t = this.classFacade.getTypeManager().getTypeForId(target);
        return this.classFacade.createUnidirectionalAssociation(name, essential, unique, s, t);
    }

    public MapAssociation createMapAssociation(String name, boolean essential, long source, long target, long key) throws PersistenceException {
        UserType s = (UserType)this.classFacade.getTypeManager().getTypeForId(source).accept((TypeVisitorReturnException)new TypeVisitorReturnException<UserType, TypeOrAssociationNotFoundException>(){

            public UserType handleUserType(UserType type) {
                return type;
            }

            public UserType handleBaseType(Type type) throws TypeOrAssociationNotFoundException {
                throw new TypeOrAssociationNotFoundException(type.getId());
            }
        });
        Type t = this.classFacade.getTypeManager().getTypeForId(target);
        Type k = this.classFacade.getTypeManager().getTypeForId(key);
        return this.classFacade.createMapAssociation(name, essential, s, t, k);
    }

    public void createSpecialisation(long ancestor, long descendant) throws PersistenceException {
        Type d = this.classFacade.getTypeManager().getTypeForId(descendant);
        UserType a = (UserType)this.classFacade.getTypeManager().getTypeForId(ancestor).accept((TypeVisitorReturnException)new TypeVisitorReturnException<UserType, TypeOrAssociationNotFoundException>(){

            public UserType handleUserType(UserType t) throws TypeOrAssociationNotFoundException {
                return t;
            }

            public UserType handleBaseType(Type t) throws TypeOrAssociationNotFoundException {
                throw new TypeOrAssociationNotFoundException(t.getId());
            }
        });
        this.classFacade.createSpecializationBetween(a, d);
    }

    public ClassFacade getClassFacade() {
        return this.classFacade;
    }
}

