package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClass;
import de.fhdw.wtf.generator.java.generatorModel.GenCollectionType;
import de.fhdw.wtf.generator.java.generatorModel.GenDummyType;
import de.fhdw.wtf.generator.java.generatorModel.GenImportType;
import de.fhdw.wtf.generator.java.generatorModel.GenJavaUtilCollection;
import de.fhdw.wtf.generator.java.generatorModel.GenMapType;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveType;
import de.fhdw.wtf.generator.java.generatorModel.Generic;

/**
 * This visitor handles all GenType-types and returns values.
 * 
 * @param <X>
 *            The type of values returned by handle-methods.
 */
public interface GenTypeVisitorReturn<X> {
	
	/**
	 * Handle method for objects of GenClass-type.
	 * 
	 * @param cla
	 *            GenClass to handle.
	 * @return Value of type X
	 */
	X handle(GenClass cla);
	
	/**
	 * Handle method for objects of GenCollectionType-type.
	 * 
	 * @param collectionType
	 *            GenCollectionType to handle.
	 * @return Value of type X
	 */
	X handle(GenCollectionType collectionType);
	
	/**
	 * Handle method for objects of GenPrimitiveType-type.
	 * 
	 * @param primitiveType
	 *            GenPrimitiveType to handle.
	 * @return Value of type X
	 */
	X handle(GenPrimitiveType primitiveType);
	
	/**
	 * Handle method for objects of GenMapType-type.
	 * 
	 * @param mapType
	 *            GenMapType to handle.
	 * @return Value of type X
	 */
	X handle(GenMapType mapType);
	
	/**
	 * Handle method for objects of GenImportType-type.
	 * 
	 * @param importType
	 *            GenImportType to handle.
	 * @return Value of type X
	 */
	X handle(GenImportType importType);
	
	/**
	 * Handle method for objects of GenDummyType-type.
	 * 
	 * @param dummyType
	 *            GenDummyType to handle.
	 * @return Value of type X
	 */
	X handle(GenDummyType dummyType);
	
	/**
	 * Handle method for objects of Generic-type.
	 * 
	 * @param generic
	 *            Generic to handle.
	 * @return Value of type X
	 */
	X handle(Generic generic);
	
	/**
	 * Handle method for objects of GenJavaUtilCollection-type.
	 * 
	 * @param javaUtilCollection
	 *            GenJavaUtilCollection to handle.
	 * @return Value of type X
	 */
	X handle(GenJavaUtilCollection javaUtilCollection);
	
}
