package de.fhdw.wtf.generator.java.visitor;

import de.fhdw.wtf.generator.java.generatorModel.GenClassClass;
import de.fhdw.wtf.generator.java.generatorModel.GenInterfaceClass;
import de.fhdw.wtf.generator.java.generatorModel.GenPrimitiveClass;

/**
 * This visitor handles all GenClass-types.
 */
public interface GenClassVisitor {
	
	/**
	 * Handle method for objects of GenClassClass-type.
	 * 
	 * @param classClass
	 *            GenClassClass to handle.
	 */
	void handle(GenClassClass classClass);
	
	/**
	 * Handle method for objects of GenInterfaceClass-type.
	 * 
	 * @param interfaceClass
	 *            GenInterfaceClass to handle.
	 */
	void handle(GenInterfaceClass interfaceClass);
	
	/**
	 * Handle method for objects of GenPrimitiveClass-type.
	 * 
	 * @param primitiveClass
	 *            GenPrimitiveClass to handle.
	 */
	void handle(GenPrimitiveClass primitiveClass);
}
